/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.batch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.batch.BatchMonitor;
import org.alfresco.repo.batch.BatchMonitorEvent;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.TraceableThreadFactory;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@AlfrescoPublicApi
public class BatchProcessor<T>
implements BatchMonitor {
    private TraceableThreadFactory threadFactory;
    private final Log logger;
    private final RetryingTransactionHelper retryingTransactionHelper;
    private BatchProcessWorkProvider<T> workProvider;
    private final String processName;
    private final int loggingInterval;
    private final int workerThreads;
    private final int batchSize;
    private String currentEntryId;
    private int executingCount;
    private SortedSet<Integer> retryTxns = new TreeSet<Integer>();
    private Throwable lastError;
    private String lastErrorEntryId;
    private long totalErrors;
    private long successfullyProcessedEntries;
    private Date startTime;
    private Date endTime;

    public BatchProcessor(String processName, RetryingTransactionHelper retryingTransactionHelper, final Collection<T> collection, int workerThreads, int batchSize, ApplicationEventPublisher applicationEventPublisher, Log logger, int loggingInterval) {
        this(processName, retryingTransactionHelper, new BatchProcessWorkProvider<T>(){
            boolean hasMore = true;

            @Override
            public int getTotalEstimatedWorkSize() {
                return (int)this.getTotalEstimatedWorkSizeLong();
            }

            @Override
            public long getTotalEstimatedWorkSizeLong() {
                return collection.size();
            }

            @Override
            public Collection<T> getNextWork() {
                if (this.hasMore) {
                    this.hasMore = false;
                    return collection;
                }
                return Collections.emptyList();
            }
        }, workerThreads, batchSize, applicationEventPublisher, logger, loggingInterval);
    }

    public BatchProcessor(String processName, RetryingTransactionHelper retryingTransactionHelper, BatchProcessWorkProvider<T> workProvider, int workerThreads, int batchSize, ApplicationEventPublisher applicationEventPublisher, Log logger, int loggingInterval) {
        this.threadFactory = new TraceableThreadFactory();
        this.threadFactory.setNamePrefix(processName);
        this.threadFactory.setThreadDaemon(true);
        this.processName = processName;
        this.retryingTransactionHelper = retryingTransactionHelper;
        this.workProvider = workProvider;
        this.workerThreads = workerThreads;
        this.batchSize = batchSize;
        this.logger = logger == null ? LogFactory.getLog(this.getClass()) : logger;
        this.loggingInterval = loggingInterval;
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new BatchMonitorEvent(this));
        }
    }

    @Override
    public synchronized String getCurrentEntryId() {
        return this.currentEntryId;
    }

    @Override
    public synchronized String getLastError() {
        if (this.lastError == null) {
            return null;
        }
        StringWriter buff = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buff);
        this.lastError.printStackTrace(out);
        out.close();
        return ((Object)buff).toString();
    }

    @Override
    public synchronized String getLastErrorEntryId() {
        return this.lastErrorEntryId;
    }

    @Override
    public synchronized String getProcessName() {
        return this.processName;
    }

    @Override
    @Deprecated
    public synchronized int getSuccessfullyProcessedEntries() {
        return Math.toIntExact(this.successfullyProcessedEntries);
    }

    @Override
    public synchronized long getSuccessfullyProcessedEntriesLong() {
        return this.successfullyProcessedEntries;
    }

    @Override
    public synchronized String getPercentComplete() {
        long processed = this.successfullyProcessedEntries + this.totalErrors;
        long totalResults = this.workProvider.getTotalEstimatedWorkSizeLong();
        return processed <= totalResults ? NumberFormat.getPercentInstance().format(totalResults == 0L ? 1.0f : (float)processed / (float)totalResults) : "Unknown";
    }

    @Override
    @Deprecated
    public synchronized int getTotalErrors() {
        return Math.toIntExact(this.totalErrors);
    }

    @Override
    @Deprecated
    public int getTotalResults() {
        return this.workProvider.getTotalEstimatedWorkSize();
    }

    @Override
    public synchronized long getTotalErrorsLong() {
        return this.totalErrors;
    }

    @Override
    public long getTotalResultsLong() {
        return this.workProvider.getTotalEstimatedWorkSizeLong();
    }

    @Override
    public synchronized Date getEndTime() {
        return this.endTime;
    }

    @Override
    public synchronized Date getStartTime() {
        return this.startTime;
    }

    @Deprecated
    public int process(BatchProcessWorker<T> worker, boolean splitTxns) {
        int count = this.workProvider.getTotalEstimatedWorkSize();
        return (int)this.process(worker, splitTxns, count);
    }

    public long processLong(BatchProcessWorker<T> worker, boolean splitTxns) {
        long count = this.workProvider.getTotalEstimatedWorkSizeLong();
        return this.process(worker, splitTxns, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long process(BatchProcessWorker<T> worker, boolean splitTxns, long count) {
        long l;
        block30: {
            BatchProcessor batchProcessor = this;
            synchronized (batchProcessor) {
                this.startTime = new Date();
                if (this.logger.isInfoEnabled()) {
                    if (count >= 0L) {
                        this.logger.info((Object)(this.getProcessName() + ": Commencing batch of " + count + " entries"));
                    } else {
                        this.logger.info((Object)(this.getProcessName() + ": Commencing batch"));
                    }
                }
            }
            ThreadPoolExecutor executorService = splitTxns && this.workerThreads > 1 ? new ThreadPoolExecutor(this.workerThreads, this.workerThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(this.workerThreads * this.batchSize * 10){

                @Override
                public boolean offer(Runnable o) {
                    try {
                        this.put(o);
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                    return true;
                }
            }, (ThreadFactory)this.threadFactory) : null;
            try {
                WorkProviderIterator<T> iterator = new WorkProviderIterator<T>(this.workProvider);
                int id = 0;
                ArrayList batch = new ArrayList(this.batchSize);
                while (iterator.hasNext()) {
                    batch.add(iterator.next());
                    boolean hasNext = iterator.hasNext();
                    if (batch.size() < this.batchSize && hasNext) continue;
                    TxnCallback callback = new TxnCallback(id++, worker, batch, splitTxns);
                    if (hasNext) {
                        batch = new ArrayList(this.batchSize);
                    }
                    if (executorService == null) {
                        callback.run();
                        continue;
                    }
                    executorService.execute(callback);
                }
                l = count;
                if (executorService == null) break block30;
                executorService.shutdown();
            }
            catch (Throwable throwable) {
                if (executorService != null) {
                    executorService.shutdown();
                    try {
                        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BatchProcessor batchProcessor2 = this;
                synchronized (batchProcessor2) {
                    this.reportProgress(true);
                    this.endTime = new Date();
                    if (this.logger.isInfoEnabled()) {
                        if (count >= 0L) {
                            this.logger.info((Object)(this.getProcessName() + ": Completed batch of " + count + " entries"));
                        } else {
                            this.logger.info((Object)(this.getProcessName() + ": Completed batch"));
                        }
                    }
                    if (this.totalErrors > 0L && this.logger.isErrorEnabled()) {
                        this.logger.error((Object)(this.getProcessName() + ": " + this.totalErrors + " error(s) detected. Last error from entry \"" + this.lastErrorEntryId + "\""), this.lastError);
                    }
                }
                throw throwable;
            }
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        BatchProcessor batchProcessor = this;
        synchronized (batchProcessor) {
            this.reportProgress(true);
            this.endTime = new Date();
            if (this.logger.isInfoEnabled()) {
                if (count >= 0L) {
                    this.logger.info((Object)(this.getProcessName() + ": Completed batch of " + count + " entries"));
                } else {
                    this.logger.info((Object)(this.getProcessName() + ": Completed batch"));
                }
            }
            if (this.totalErrors > 0L && this.logger.isErrorEnabled()) {
                this.logger.error((Object)(this.getProcessName() + ": " + this.totalErrors + " error(s) detected. Last error from entry \"" + this.lastErrorEntryId + "\""), this.lastError);
            }
        }
        return l;
    }

    private synchronized void reportProgress(boolean last) {
        long processed = this.successfullyProcessedEntries + this.totalErrors;
        if (processed % (long)this.loggingInterval == 0L ^ last) {
            long duration;
            StringBuilder message = new StringBuilder(100).append(this.getProcessName()).append(": Processed ").append(processed).append(" entries");
            long totalResults = 0L;
            try {
                totalResults = this.workProvider.getTotalEstimatedWorkSizeLong();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                totalResults = this.workProvider.getTotalEstimatedWorkSize();
            }
            if (totalResults >= processed) {
                message.append(" out of ").append(totalResults).append(". ").append(NumberFormat.getPercentInstance().format(totalResults == 0L ? 1.0f : (float)processed / (float)totalResults)).append(" complete");
            }
            if ((duration = System.currentTimeMillis() - this.startTime.getTime()) > 0L) {
                message.append(". Rate: ").append(processed * 1000L / duration).append(" per second");
            }
            message.append(". " + this.totalErrors + " failures detected.");
            this.logger.info((Object)message);
        }
    }

    public static interface BatchProcessWorker<T> {
        public String getIdentifier(T var1);

        public void beforeProcess() throws Throwable;

        public void process(T var1) throws Throwable;

        public void afterProcess() throws Throwable;
    }

    @AlfrescoPublicApi
    public static abstract class BatchProcessWorkerAdaptor<TT>
    implements BatchProcessWorker<TT> {
        @Override
        public String getIdentifier(TT entry) {
            return entry.toString();
        }

        @Override
        public void beforeProcess() throws Throwable {
        }

        @Override
        public void afterProcess() throws Throwable {
        }
    }

    class TxnCallback
    extends TransactionListenerAdapter
    implements RetryingTransactionHelper.RetryingTransactionCallback<Object>,
    Runnable {
        private final int id;
        private final BatchProcessWorker<T> worker;
        private final List<T> batch;
        private final boolean splitTxns;
        private int txnErrors;
        private int txnSuccesses;
        private String txnEntryId;
        private Throwable txnLastError;
        private String txnLastErrorEntryId;

        public TxnCallback(int id, BatchProcessWorker<T> worker, List<T> batch, boolean splitTxns) {
            this.id = id;
            this.worker = worker;
            this.batch = batch;
            this.splitTxns = splitTxns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() throws Throwable {
            this.reset();
            if (this.batch.isEmpty()) {
                return null;
            }
            AlfrescoTransactionSupport.bindListener((TransactionListener)this);
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                if (BatchProcessor.this.logger.isDebugEnabled()) {
                    BatchProcessor.this.logger.debug((Object)("RETRY TXNS: " + String.valueOf(BatchProcessor.this.retryTxns)));
                }
                while (!BatchProcessor.this.retryTxns.isEmpty() && (BatchProcessor.this.retryTxns.first() < this.id || BatchProcessor.this.retryTxns.first() == this.id && BatchProcessor.this.executingCount > 0) && BatchProcessor.this.retryTxns.last() >= this.id) {
                    if (BatchProcessor.this.logger.isDebugEnabled()) {
                        BatchProcessor.this.logger.debug((Object)(Thread.currentThread().getName() + " Recoverable failure: waiting for other batches to complete"));
                    }
                    BatchProcessor.this.wait();
                }
                if (BatchProcessor.this.logger.isDebugEnabled()) {
                    BatchProcessor.this.logger.debug((Object)(Thread.currentThread().getName() + " ready to execute"));
                }
                BatchProcessor.this.currentEntryId = this.worker.getIdentifier(this.batch.get(0));
                ++BatchProcessor.this.executingCount;
            }
            for (Object entry : this.batch) {
                this.txnEntryId = this.worker.getIdentifier(entry);
                try {
                    this.worker.process(entry);
                    ++this.txnSuccesses;
                }
                catch (Throwable t) {
                    if (RetryingTransactionHelper.extractRetryCause(t) == null) {
                        if (BatchProcessor.this.logger.isWarnEnabled()) {
                            BatchProcessor.this.logger.warn((Object)(BatchProcessor.this.getProcessName() + ": Failed to process entry \"" + this.txnEntryId + "\"."), t);
                        }
                        this.txnLastError = t;
                        this.txnLastErrorEntryId = this.txnEntryId;
                        ++this.txnErrors;
                        continue;
                    }
                    throw t;
                }
            }
            return null;
        }

        @Override
        public void run() {
            TxnCallback callback = this;
            try {
                Throwable tt = null;
                this.worker.beforeProcess();
                try {
                    BatchProcessor.this.retryingTransactionHelper.doInTransaction(callback, false, this.splitTxns);
                }
                catch (Throwable t) {
                    tt = t;
                }
                this.worker.afterProcess();
                if (tt != null) {
                    throw tt;
                }
            }
            catch (Throwable t) {
                if (this.splitTxns) {
                    this.txnLastError = t;
                    this.txnLastErrorEntryId = t instanceof IntegrityException ? "unknown" : this.txnEntryId;
                    ++this.txnErrors;
                    if (BatchProcessor.this.logger.isWarnEnabled()) {
                        String message = t instanceof IntegrityException ? ": Failed on batch commit." : ": Failed to process entry \"" + this.txnEntryId + "\".";
                        BatchProcessor.this.logger.warn((Object)(BatchProcessor.this.getProcessName() + message), t);
                    }
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new AlfrescoRuntimeException("Transactional error during " + BatchProcessor.this.getProcessName(), t);
            }
            this.commitProgress();
        }

        private void reset() {
            this.txnLastError = null;
            this.txnLastErrorEntryId = null;
            this.txnErrors = 0;
            this.txnSuccesses = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitProgress() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                long intervals;
                long currentIncrement;
                long processed;
                if (this.txnErrors > 0) {
                    processed = BatchProcessor.this.successfullyProcessedEntries + BatchProcessor.this.totalErrors;
                    currentIncrement = processed % (long)BatchProcessor.this.loggingInterval;
                    long newErrors = BatchProcessor.this.totalErrors + (long)this.txnErrors;
                    intervals = ((long)this.txnErrors + currentIncrement) / (long)BatchProcessor.this.loggingInterval;
                    if (intervals > 0L) {
                        BatchProcessor.this.totalErrors += (long)BatchProcessor.this.loggingInterval - currentIncrement;
                        BatchProcessor.this.reportProgress(false);
                        while (--intervals > 0L) {
                            BatchProcessor.this.totalErrors += (long)BatchProcessor.this.loggingInterval;
                            BatchProcessor.this.reportProgress(false);
                        }
                    }
                    BatchProcessor.this.totalErrors = newErrors;
                }
                if (this.txnSuccesses > 0) {
                    processed = BatchProcessor.this.successfullyProcessedEntries + BatchProcessor.this.totalErrors;
                    currentIncrement = processed % (long)BatchProcessor.this.loggingInterval;
                    long newSuccess = BatchProcessor.this.successfullyProcessedEntries + (long)this.txnSuccesses;
                    intervals = ((long)this.txnSuccesses + currentIncrement) / (long)BatchProcessor.this.loggingInterval;
                    if (intervals > 0L) {
                        BatchProcessor.this.successfullyProcessedEntries += (long)BatchProcessor.this.loggingInterval - currentIncrement;
                        BatchProcessor.this.reportProgress(false);
                        while (--intervals > 0L) {
                            BatchProcessor.this.successfullyProcessedEntries += (long)BatchProcessor.this.loggingInterval;
                            BatchProcessor.this.reportProgress(false);
                        }
                    }
                    BatchProcessor.this.successfullyProcessedEntries = newSuccess;
                }
                if (this.txnLastError != null) {
                    BatchProcessor.this.lastError = this.txnLastError;
                    BatchProcessor.this.lastErrorEntryId = this.txnLastErrorEntryId;
                }
                this.reset();
                BatchProcessor.this.retryTxns.remove(this.id);
                BatchProcessor.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCommit() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                --BatchProcessor.this.executingCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRollback() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                --BatchProcessor.this.executingCount;
                BatchProcessor.this.retryTxns.add(this.id);
                BatchProcessor.this.notifyAll();
            }
        }
    }

    private static class WorkProviderIterator<T>
    implements Iterator<T> {
        private BatchProcessWorkProvider<T> workProvider;
        private Iterator<T> currentIterator;

        private WorkProviderIterator(BatchProcessWorkProvider<T> workProvider) {
            this.workProvider = workProvider;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            if (this.workProvider == null) {
                hasNext = false;
            } else {
                if (this.currentIterator != null) {
                    hasNext = this.currentIterator.hasNext();
                }
                if (!hasNext) {
                    Collection<T> nextWork = this.workProvider.getNextWork();
                    if (nextWork == null) {
                        throw new RuntimeException("BatchProcessWorkProvider returned 'null' work: " + String.valueOf(this.workProvider));
                    }
                    if (nextWork.size() == 0) {
                        this.workProvider = null;
                        this.currentIterator = null;
                        hasNext = false;
                    } else {
                        this.currentIterator = nextWork.iterator();
                        hasNext = this.currentIterator.hasNext();
                    }
                }
            }
            return hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

