/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bootstrap;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.WellKnownNodes;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class DataDictionaryFolderTest
extends BaseSpringTest {
    @ClassRule
    public static final ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    private static final String DATA_DICTIONARY = "Data Dictionary";
    @Rule
    public WellKnownNodes wellKnownNodes = new WellKnownNodes(APP_CONTEXT_INIT);
    private NodeService nodeService;

    @Before
    public void before() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
    }

    @Test
    public void testDataDictionaryFolderIsUndeletable() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef companyHomeRef = this.wellKnownNodes.getCompanyHome();
        NodeRef dataDictionaryRef = this.nodeService.getChildByName(companyHomeRef, ContentModel.ASSOC_CONTAINS, DATA_DICTIONARY);
        DataDictionaryFolderTest.assertTrue((boolean)this.nodeService.hasAspect(dataDictionaryRef, ContentModel.ASPECT_UNDELETABLE));
        List chilAssocsList = this.nodeService.getChildAssocs(dataDictionaryRef);
        chilAssocsList.stream().map(ChildAssociationRef::getChildRef).forEach(childNodeRef -> {
            DataDictionaryFolderTest.assertTrue((boolean)this.nodeService.hasAspect(childNodeRef, ContentModel.ASPECT_UNDELETABLE));
            try {
                this.nodeService.deleteNode(childNodeRef);
            }
            catch (Exception ex) {
                DataDictionaryFolderTest.assertTrue((boolean)ex.getMessage().contains("deletion is not allowed"));
            }
        });
    }

    @Test
    public void testDataDictionaryFolderIsUnmovable() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef companyHomeRef = this.wellKnownNodes.getCompanyHome();
        NodeRef dataDictionaryRef = this.nodeService.getChildByName(companyHomeRef, ContentModel.ASSOC_CONTAINS, DATA_DICTIONARY);
        DataDictionaryFolderTest.assertTrue((boolean)this.nodeService.hasAspect(dataDictionaryRef, ContentModel.ASPECT_UNMOVABLE));
        List chilAssocsList = this.nodeService.getChildAssocs(dataDictionaryRef);
        chilAssocsList.stream().map(ChildAssociationRef::getChildRef).forEach(childNodeRef -> {
            DataDictionaryFolderTest.assertTrue((boolean)this.nodeService.hasAspect(childNodeRef, ContentModel.ASPECT_UNMOVABLE));
            NodeRef folderRef = this.nodeService.createNode(companyHomeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)("testDeleteAndRestore-folder2-" + System.currentTimeMillis())), ContentModel.TYPE_FOLDER).getChildRef();
            try {
                this.nodeService.moveNode(childNodeRef, folderRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
            }
            catch (Exception ex) {
                DataDictionaryFolderTest.assertTrue((boolean)ex.getMessage().contains("move is not allowed"));
            }
        });
    }
}

