/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.calendar;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class CalendarRecurrenceHelper {
    private static Log logger = LogFactory.getLog(CalendarRecurrenceHelper.class);
    protected static final Map<String, Integer> d2cd = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("SU", 1);
            this.put("MO", 2);
            this.put("TU", 3);
            this.put("WE", 4);
            this.put("TH", 5);
            this.put("FR", 6);
            this.put("SA", 7);
        }
    });
    public static final Map<String, Integer> DAY_NAMES_TO_CALENDAR_DAYS = Collections.unmodifiableMap(d2cd);
    public static final String DAY = "day";
    public static final String WEEKDAYS = "weekday";
    public static final String WEEKENDS = "weekend day";
    protected static final Map<Integer, String> WEEK_NUMBER_TO_WEEK_NAME = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(1, "first");
            this.put(2, "second");
            this.put(3, "third");
            this.put(4, "fourth");
            this.put(-1, "last");
        }
    });

    public static Map<String, String> buildLocalRecurrenceDaysOfTheWeek(Locale locale) {
        DateFormatSymbols dates = new DateFormatSymbols(I18NUtil.getLocale());
        String[] weekdays = dates.getWeekdays();
        HashMap<String, String> days = new HashMap<String, String>();
        for (Map.Entry<String, Integer> e : DAY_NAMES_TO_CALENDAR_DAYS.entrySet()) {
            days.put(e.getKey(), weekdays[e.getValue()]);
        }
        return days;
    }

    public static Map<Integer, String> buildLocalRecurrenceWeekNames(Locale locale) {
        return WEEK_NUMBER_TO_WEEK_NAME;
    }

    public static Map<String, String> extractRecurrenceRule(CalendarEntry entry) {
        return CalendarRecurrenceHelper.extractRecurrenceRule(entry.getRecurrenceRule());
    }

    private static Map<String, String> extractRecurrenceRule(String recurrenceRule) {
        if (recurrenceRule == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = recurrenceRule.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            String[] parts = rule.split("=");
            if (parts.length != 2) {
                logger.warn((Object)("Invalid rule '" + rule + "' in recurrence: " + recurrenceRule));
            } else {
                params.put(parts[0], parts[1]);
            }
            ++n2;
        }
        return params;
    }

    protected static Map<String, String> fixOutlookRecurrenceQuirks(Map<String, String> params) {
        if (params.containsKey("FREQ")) {
            if ("MONTHLY".equals(params.get("FREQ")) && params.get("BYMONTH") != null) {
                params.put("FREQ", "YEARLY");
                String intervalString = params.get("INTERVAL");
                if (intervalString != null) {
                    int interval = Integer.parseInt(intervalString);
                    params.put("INTERVAL", String.valueOf(interval / 12));
                }
                if (params.containsKey("BYDAY") && params.containsKey("BYSETPOS")) {
                    int days = params.get("BYDAY").split(",").length;
                    if (days == 7 && !"-1".equals(params.get("BYSETPOS"))) {
                        params.put("BYMONTHDAY", params.get("BYSETPOS"));
                        params.remove("BYDAY");
                        params.remove("BYSETPOS");
                    } else {
                        CalendarRecurrenceHelper.buildParams(params, days);
                    }
                }
            } else if ("MONTHLY".equals(params.get("FREQ")) && params.containsKey("BYDAY") && params.containsKey("BYSETPOS")) {
                int days = params.get("BYDAY").split(",").length;
                CalendarRecurrenceHelper.buildParams(params, days);
            }
        }
        return params;
    }

    private static void buildParams(Map<String, String> params, int days) {
        if (days == 7) {
            params.put("BYANYDAY", params.get("BYSETPOS"));
            params.put("DAY", params.get("BYDAY"));
            params.remove("BYDAY");
            params.remove("BYSETPOS");
        } else if (days == 5) {
            params.put("BYWEEKDAY", params.get("BYSETPOS"));
            params.put("WEEKDAYS", params.get("BYDAY"));
            params.remove("BYDAY");
            params.remove("BYSETPOS");
        } else if (days == 2) {
            params.put("BYWEEKENDDAY", params.get("BYSETPOS"));
            params.put("WEEKENDS", params.get("BYDAY"));
            params.remove("BYDAY");
            params.remove("BYSETPOS");
        }
    }

    public static List<Date> getRecurrencesOnOrAfter(CalendarEntry entry, Date onOrAfter, Date until, boolean firstOnly, Set<Date> ignoredDates) {
        return CalendarRecurrenceHelper.getRecurrencesOnOrAfter(entry.getRecurrenceRule(), entry.getStart(), entry.getEnd(), entry.getLastRecurrence(), onOrAfter, until, firstOnly, ignoredDates);
    }

    public static List<Date> getRecurrencesOnOrAfter(String recurrenceRule, Date eventStart, Date eventEnd, Date lastRecurrence, Date onOrAfter, Date until, boolean firstOnly, Set<Date> ignoredDates) {
        if (recurrenceRule == null) {
            return null;
        }
        if (lastRecurrence != null && lastRecurrence.before(onOrAfter)) {
            return null;
        }
        if (lastRecurrence != null) {
            if (until == null) {
                until = lastRecurrence;
            } else if (lastRecurrence.before(until)) {
                until = lastRecurrence;
            }
        }
        if (lastRecurrence == null && !firstOnly && until == null) {
            logger.info((Object)"No end date set on the recurring event, and no end date specified, only fetching first instance");
            firstOnly = true;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        Map<String, String> params = CalendarRecurrenceHelper.extractRecurrenceRule(recurrenceRule);
        if ((params = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks(params)).containsKey("FREQ")) {
            String freq = params.get("FREQ");
            String intervalS = params.get("INTERVAL");
            int interval = 1;
            if (intervalS != null) {
                try {
                    interval = Integer.parseInt(intervalS);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn((Object)("Invalid interval " + intervalS));
                }
            }
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(eventStart);
            long duration = eventEnd.getTime() - eventStart.getTime();
            if ("DAILY".equals(freq)) {
                CalendarRecurrenceHelper.buildDailyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("WEEKLY".equals(freq)) {
                CalendarRecurrenceHelper.buildWeeklyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("MONTHLY".equals(freq)) {
                CalendarRecurrenceHelper.buildMonthlyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("YEARLY".equals(freq)) {
                CalendarRecurrenceHelper.buildYearlyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else {
                logger.warn((Object)("Unsupported recurrence frequency " + freq));
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            for (Date ignoredDate : ignoredDates) {
                Iterator i = dates.iterator();
                while (i.hasNext()) {
                    Date date = (Date)i.next();
                    if (!fmt.format(date).equals(fmt.format(ignoredDate))) continue;
                    i.remove();
                }
            }
            return dates;
        }
        logger.warn((Object)("No frequency found, possible invalid rule? " + recurrenceRule));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected static void buildDailyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        block7: {
            if (onOrAfter.before(currentDate.getTime())) {
                onOrAfter = currentDate.getTime();
            }
            while (currentDate.getTime().before(onOrAfter)) {
                currentDate.add(5, interval);
            }
            currentDate.add(5, -1 * interval * 2);
            currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                currentDate.add(5, interval);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            if (!firstOnly) ** GOTO lbl24
            if (until != null) {
                if (currentDate.getTime().before(until)) {
                    dates.add(currentDate.getTime());
                }
            } else {
                dates.add(currentDate.getTime());
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                dates.add(currentDate.getTime());
                currentDate.add(5, interval);
lbl24:
                // 2 sources

                ** while (!currentDate.getTime().after((Date)until))
            }
        }
    }

    protected static void buildWeeklyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        ArrayList<Integer> daysOfWeek = new ArrayList<Integer>();
        String[] stringArray = params.get("BYDAY").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dayS = stringArray[n2];
            Integer day = DAY_NAMES_TO_CALENDAR_DAYS.get(dayS);
            if (day == null) {
                logger.warn((Object)("Invalid day " + dayS));
            } else {
                daysOfWeek.add(day);
            }
            ++n2;
        }
        Collections.sort(daysOfWeek);
        boolean going = true;
        boolean valid = false;
        Date origDate = currentDate.getTime();
        currentDate.add(5, -1 * interval * 7 * 2);
        while (going) {
            Iterator iterator = daysOfWeek.iterator();
            while (iterator.hasNext()) {
                Date currentEventEnd;
                int day = (Integer)iterator.next();
                currentDate.set(7, day);
                if (!(valid || (currentEventEnd = new Date(currentDate.getTimeInMillis() + duration)).before(onOrAfter) || currentEventEnd.before(origDate))) {
                    valid = true;
                }
                if (!valid) continue;
                if (until != null && currentDate.getTime().after(until)) {
                    going = false;
                    break;
                }
                dates.add(currentDate.getTime());
                if (!firstOnly) continue;
                going = false;
                break;
            }
            currentDate.set(7, (Integer)daysOfWeek.get(0));
            currentDate.add(5, interval * 7);
        }
    }

    protected static void buildMonthlyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int monthInterval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        if (params.get("BYMONTHDAY") != null) {
            currentDate.add(2, -1 * monthInterval * 2);
            int dayOfMonth = Integer.parseInt(params.get("BYMONTHDAY"));
            if (currentDate.get(5) > dayOfMonth) {
                CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
            } else {
                currentDate.set(5, dayOfMonth);
                if (currentDate.get(5) != dayOfMonth) {
                    currentDate.add(5, -1);
                }
            }
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
                    continue;
                }
                break;
            }
        } else if (params.get("BYSETPOS") != null) {
            int dayOfWeek = -1;
            int instanceInMonth = 1;
            if (params.containsKey("BYDAY")) {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYDAY"));
                instanceInMonth = Integer.parseInt(params.get("BYSETPOS"));
            } else {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYSETPOS"));
                instanceInMonth = 1;
            }
            Date origDate = currentDate.getTime();
            currentDate.add(2, -1 * monthInterval * 2);
            CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            if (currentEventEnd.before(origDate)) {
                CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (currentEventEnd.before(onOrAfter)) {
                CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                    CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                    continue;
                }
                break;
            }
        }
        if (params.get("BYWEEKDAY") != null || params.get("BYWEEKENDDAY") != null || params.get("BYANYDAY") != null) {
            CalendarRecurrenceHelper.buildWeekdayAndWeekEndRecurence(currentDate, dates, params, until, monthInterval);
        }
    }

    private static void buildWeekdayAndWeekEndRecurence(Calendar currentDate, List<Date> dates, Map<String, String> params, Date until, int intervalInMonths) {
        String dayWeekType;
        String dayPosStr;
        if (params.get("BYWEEKDAY") != null) {
            dayPosStr = params.get("BYWEEKDAY");
            dayWeekType = "WEEKDAYS";
        } else if (params.get("BYWEEKENDDAY") != null) {
            dayPosStr = params.get("BYWEEKENDDAY");
            dayWeekType = "WEEKENDS";
        } else {
            dayPosStr = params.get("BYANYDAY");
            dayWeekType = "DAY";
        }
        List<Integer> daysOfWeek = CalendarRecurrenceHelper.getDaysOfWeek(params, dayWeekType);
        boolean isCurrentDateAfterUntil = false;
        int firstMonthDay = 1;
        while (!isCurrentDateAfterUntil) {
            currentDate.set(5, firstMonthDay);
            if (currentDate.getTime().before(until)) {
                int dayCount = 0;
                int weekDayPos = Integer.parseInt(dayPosStr);
                if (weekDayPos > 0) {
                    currentDate.set(5, firstMonthDay);
                    while (dayCount != weekDayPos) {
                        currentDayOfWeek = currentDate.get(7);
                        if (daysOfWeek.contains(currentDayOfWeek)) {
                            ++dayCount;
                        }
                        if (dayCount == weekDayPos) continue;
                        currentDate.add(5, 1);
                    }
                } else {
                    currentDate.set(5, currentDate.getActualMaximum(5));
                    currentDayOfWeek = currentDate.get(7);
                    while (!daysOfWeek.contains(currentDayOfWeek)) {
                        currentDate.add(5, -1);
                        currentDayOfWeek = currentDate.get(7);
                    }
                }
                dates.add(currentDate.getTime());
                currentDate.add(2, intervalInMonths);
                continue;
            }
            isCurrentDateAfterUntil = true;
        }
    }

    private static List<Integer> getDaysOfWeek(Map<String, String> params, String dayWeekType) {
        String[] weekDays = params.get(dayWeekType).split(",");
        ArrayList<Integer> daysOfWeek = new ArrayList<Integer>();
        String[] stringArray = weekDays;
        int n = weekDays.length;
        int n2 = 0;
        while (n2 < n) {
            String day = stringArray[n2];
            Integer dayNumber = DAY_NAMES_TO_CALENDAR_DAYS.get(day);
            if (dayNumber == null) {
                logger.warn((Object)("Invalid day " + day));
            } else {
                daysOfWeek.add(dayNumber);
            }
            ++n2;
        }
        Collections.sort(daysOfWeek);
        return daysOfWeek;
    }

    protected static void buildYearlyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        int realMonth = Integer.parseInt(params.get("BYMONTH"));
        int month = realMonth - 1;
        if (params.get("BYMONTHDAY") != null) {
            currentDate.add(1, -1 * interval * 2);
            int dayOfMonth = Integer.parseInt(params.get("BYMONTHDAY"));
            if (currentDate.get(2) != month || currentDate.get(5) != dayOfMonth) {
                if (currentDate.get(2) < month || currentDate.get(2) == month && currentDate.get(5) < dayOfMonth) {
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                } else {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                }
            }
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, dayOfMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                    continue;
                }
                break;
            }
        } else if (params.get("BYWEEKDAY") != null || params.get("BYWEEKENDDAY") != null || params.get("BYANYDAY") != null) {
            int intervalInMonths = interval * 12;
            CalendarRecurrenceHelper.buildWeekdayAndWeekEndRecurence(currentDate, dates, params, until, intervalInMonths);
        } else {
            int dayOfWeek = -1;
            int instanceInMonth = 1;
            if (params.containsKey("BYDAY")) {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYDAY"));
                instanceInMonth = Integer.parseInt(params.get("BYSETPOS"));
            } else {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYSETPOS"));
                instanceInMonth = 1;
            }
            currentDate.add(1, -1 * interval * 2);
            Date origDate = currentDate.getTime();
            currentDate.set(2, month);
            currentDate.set(5, 1);
            CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            Date thisYear = currentDate.getTime();
            currentDate.setTime(origDate);
            if (currentDate.getTime().after(thisYear)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, 1);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            } else {
                currentDate.setTime(thisYear);
            }
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, 1);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, 1);
                    CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                    continue;
                }
                break;
            }
        }
    }

    private static void addMonthToDayOfMonth(Calendar c, int dayOfMonth, int monthInterval) {
        int i = 0;
        while (i < monthInterval) {
            c.set(5, 1);
            c.add(5, 33);
            c.set(5, dayOfMonth);
            if (c.get(5) != dayOfMonth) {
                c.set(5, 1);
                c.add(5, -1);
            }
            ++i;
        }
    }

    private static void addMonthToFirstDayOfWeek(Calendar c, int dayOfWeek, int monthInterval) {
        CalendarRecurrenceHelper.addMonthToDayOfMonth(c, 1, monthInterval);
        CalendarRecurrenceHelper.toDayOfWeekInMonth(c, dayOfWeek, 1);
    }

    private static void toDayOfWeekInMonth(Calendar c, int dayOfWeek, int weekInMonth) {
        c.set(5, 1);
        c.set(7, dayOfWeek);
        c.set(8, weekInMonth);
    }
}

