/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat.jobs;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.heartbeat.jobs.LockingJob;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LockingJobTest {
    private HBDataSenderService mockDataSenderService;
    private JobLockService mockJobLockService;
    private HeartBeatJobScheduler mockScheduler;

    @Before
    public void setUp() {
        this.mockDataSenderService = (HBDataSenderService)Mockito.mock(HBDataSenderService.class);
        this.mockJobLockService = (JobLockService)Mockito.mock(JobLockService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
    }

    @Test
    public void testJobInClusterNotLocked() throws Exception {
        JobExecutionContext mockJobExecutionContext = (JobExecutionContext)Mockito.mock(JobExecutionContext.class);
        SimpleHBDataCollector simpleCollector = (SimpleHBDataCollector)((Object)Mockito.spy((Object)((Object)new SimpleHBDataCollector("simpleCollector"))));
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("collector", (Object)simpleCollector);
        jobDataMap.put("hbDataSenderService", (Object)this.mockDataSenderService);
        jobDataMap.put("jobLockService", (Object)this.mockJobLockService);
        JobDetail jobDetail = JobBuilder.newJob().setJobData(jobDataMap).ofType(LockingJob.class).build();
        Mockito.when((Object)mockJobExecutionContext.getJobDetail()).thenReturn((Object)jobDetail);
        String lockToken = "locked";
        Runnable r1 = () -> {
            Mockito.when((Object)this.mockJobLockService.getLock((QName)ArgumentMatchers.isA(QName.class), ArgumentMatchers.anyLong())).thenReturn((Object)lockToken).thenThrow(new Throwable[]{new LockAcquisitionException("", new Object[]{""})});
            try {
                try {
                    new LockingJob().execute(mockJobExecutionContext);
                }
                catch (JobExecutionException jobExecutionException) {
                    Mockito.when((Object)this.mockJobLockService.getLock((QName)ArgumentMatchers.isA(QName.class), ArgumentMatchers.anyLong())).thenReturn((Object)lockToken);
                }
            }
            finally {
                Mockito.when((Object)this.mockJobLockService.getLock((QName)ArgumentMatchers.isA(QName.class), ArgumentMatchers.anyLong())).thenReturn((Object)lockToken);
            }
        };
        Runnable r2 = () -> {
            try {
                new LockingJob().execute(mockJobExecutionContext);
            }
            catch (JobExecutionException jobExecutionException) {}
        };
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        Thread.sleep(500L);
        t2.start();
        Thread.sleep(1000L);
        ((SimpleHBDataCollector)((Object)Mockito.verify((Object)((Object)simpleCollector), (VerificationMode)Mockito.times((int)2)))).collectData();
        ((HBDataSenderService)Mockito.verify((Object)this.mockDataSenderService, (VerificationMode)Mockito.times((int)2))).sendData((List)ArgumentMatchers.any(List.class));
        ((HBDataSenderService)Mockito.verify((Object)this.mockDataSenderService, (VerificationMode)Mockito.times((int)0))).sendData((HBData)ArgumentMatchers.any(HBData.class));
        ((JobLockService)Mockito.verify((Object)this.mockJobLockService, (VerificationMode)Mockito.times((int)2))).getLock((QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyLong());
        ((JobLockService)Mockito.verify((Object)this.mockJobLockService, (VerificationMode)Mockito.times((int)2))).refreshLock((String)ArgumentMatchers.eq((Object)lockToken), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyLong(), (JobLockService.JobLockRefreshCallback)ArgumentMatchers.any(JobLockService.JobLockRefreshCallback.class));
    }

    @Test
    public void testJobLocking() throws Exception {
        HBBaseDataCollector simpleCollector = (HBBaseDataCollector)Mockito.mock(HBBaseDataCollector.class);
        Mockito.when((Object)simpleCollector.getCollectorId()).thenReturn((Object)"c1");
        Mockito.when((Object)simpleCollector.getCronExpression()).thenReturn((Object)"0 0 0 ? * *");
        JobExecutionContext mockJobExecutionContext = (JobExecutionContext)Mockito.mock(JobExecutionContext.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("collector", (Object)simpleCollector);
        jobDataMap.put("hbDataSenderService", (Object)this.mockDataSenderService);
        jobDataMap.put("jobLockService", (Object)this.mockJobLockService);
        JobDetail jobDetail = JobBuilder.newJob().setJobData(jobDataMap).ofType(LockingJob.class).build();
        Mockito.when((Object)mockJobExecutionContext.getJobDetail()).thenReturn((Object)jobDetail);
        String lockToken = "token";
        Mockito.when((Object)this.mockJobLockService.getLock((QName)ArgumentMatchers.isA(QName.class), ArgumentMatchers.anyLong())).thenReturn((Object)lockToken).thenThrow(new Throwable[]{new LockAcquisitionException("", new Object[]{""})});
        new LockingJob().execute(mockJobExecutionContext);
        new LockingJob().execute(mockJobExecutionContext);
        ((HBBaseDataCollector)Mockito.verify((Object)simpleCollector, (VerificationMode)Mockito.times((int)1))).collectData();
        ((HBDataSenderService)Mockito.verify((Object)this.mockDataSenderService, (VerificationMode)Mockito.times((int)1))).sendData((List)ArgumentMatchers.any(List.class));
        ((HBDataSenderService)Mockito.verify((Object)this.mockDataSenderService, (VerificationMode)Mockito.times((int)0))).sendData((HBData)ArgumentMatchers.any(HBData.class));
        ((JobLockService)Mockito.verify((Object)this.mockJobLockService, (VerificationMode)Mockito.times((int)2))).getLock((QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyLong());
        ((JobLockService)Mockito.verify((Object)this.mockJobLockService, (VerificationMode)Mockito.times((int)1))).refreshLock((String)ArgumentMatchers.eq((Object)lockToken), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyLong(), (JobLockService.JobLockRefreshCallback)ArgumentMatchers.any(JobLockService.JobLockRefreshCallback.class));
    }

    private class SimpleHBDataCollector
    extends HBBaseDataCollector {
        public SimpleHBDataCollector(String collectorId) {
            super(collectorId, "1.0", "0 0 0 ? * *", LockingJobTest.this.mockScheduler);
        }

        public List<HBData> collectData() {
            LinkedList<HBData> result = new LinkedList<HBData>();
            result.add(new HBData("systemId2", this.getCollectorId(), "1", new Date()));
            return result;
        }
    }
}

