/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.util.Random;
import org.alfresco.repo.content.filestore.TimeBasedFileContentUrlProvider;
import org.alfresco.util.GUID;

class VolumeAwareContentUrlProvider
extends TimeBasedFileContentUrlProvider {
    private String[] volumes;
    private Random random = new Random();

    public VolumeAwareContentUrlProvider(String volumeNames) {
        if (volumeNames == null || volumeNames.isEmpty()) {
            throw new IllegalArgumentException("Invalid volumeNames argument");
        }
        this.volumes = volumeNames.split(",");
    }

    @Override
    public String createNewFileStoreUrl() {
        StringBuilder sb = new StringBuilder(20);
        sb.append("store").append("://").append(this.chooseVolume()).append("/").append(TimeBasedFileContentUrlProvider.createTimeBasedPath(this.bucketsPerMinute)).append(GUID.generate()).append(".bin");
        String newContentUrl = sb.toString();
        return newContentUrl;
    }

    private String chooseVolume() {
        int volumesNum = this.volumes.length;
        return this.volumes[this.random.nextInt(volumesNum)];
    }
}

