/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.attributes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.repo.attributes.TestIdentifier;
import org.alfresco.repo.domain.propval.DefaultPropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropValGenerator;
import org.alfresco.repo.domain.propval.PropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.domain.propval.PropertyValueEntity;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.attributes.DuplicateAttributeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.mutable.MutableInt;
import org.springframework.context.ApplicationContext;

public class AttributeServiceTest
extends TestCase {
    private static final Serializable KEY_A = "a";
    private static final Serializable[] KEY_AAA = new Serializable[]{"a", "a", "a"};
    private static final Serializable[] KEY_AAB = new Serializable[]{"a", "a", "b"};
    private static final Serializable[] KEY_AAC = new Serializable[]{"a", "a", "c"};
    private static final Serializable VALUE_AAA_STRING = "aaa";
    private static final Serializable VALUE_AAB_STRING = "aab";
    private static final Serializable VALUE_AAC_STRING = "aac";
    private ApplicationContext ctx;
    private AttributeService attributeService;
    private PropertyValueDAO propertyValueDAO;

    protected void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.attributeService = (AttributeService)this.ctx.getBean("AttributeService");
        this.propertyValueDAO = (PropertyValueDAO)this.ctx.getBean("propertyValueDAO");
    }

    protected void tearDown() throws Exception {
    }

    public void testBasic() throws Exception {
        this.attributeService.removeAttribute(KEY_AAA);
        this.attributeService.removeAttribute(KEY_AAB);
        this.attributeService.removeAttribute(KEY_AAC);
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAA));
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAB));
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAC));
        this.attributeService.setAttribute(VALUE_AAA_STRING, KEY_AAA);
        this.attributeService.setAttribute(VALUE_AAB_STRING, KEY_AAB);
        this.attributeService.setAttribute(VALUE_AAC_STRING, KEY_AAC);
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAA));
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAB));
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAC));
        AttributeServiceTest.assertEquals((Object)VALUE_AAA_STRING, (Object)this.attributeService.getAttribute(KEY_AAA));
        AttributeServiceTest.assertEquals((Object)VALUE_AAB_STRING, (Object)this.attributeService.getAttribute(KEY_AAB));
        AttributeServiceTest.assertEquals((Object)VALUE_AAC_STRING, (Object)this.attributeService.getAttribute(KEY_AAC));
        try {
            this.attributeService.exists(new Serializable[]{"a", "a", "a", "a", "a"});
            AttributeServiceTest.fail((String)"You can't have more than 3 keys");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testGetAttributes() throws Exception {
        this.attributeService.setAttribute(VALUE_AAA_STRING, KEY_AAA);
        this.attributeService.setAttribute(VALUE_AAB_STRING, KEY_AAB);
        this.attributeService.setAttribute(VALUE_AAC_STRING, KEY_AAC);
        final ArrayList results = new ArrayList();
        final MutableInt counter = new MutableInt();
        final MutableInt max = new MutableInt(3);
        AttributeService.AttributeQueryCallback callback = new AttributeService.AttributeQueryCallback(){

            public boolean handleAttribute(Long id, Serializable value, Serializable[] keys) {
                counter.increment();
                results.add(value);
                return counter.intValue() != max.intValue();
            }
        };
        counter.setValue(0);
        max.setValue(3);
        results.clear();
        this.attributeService.getAttributes(callback, new Serializable[]{KEY_A});
        AttributeServiceTest.assertEquals((int)3, (int)results.size());
        AttributeServiceTest.assertEquals((int)3, (int)counter.getValue());
        counter.setValue(0);
        max.setValue(2);
        results.clear();
        this.attributeService.getAttributes(callback, new Serializable[]{KEY_A});
        AttributeServiceTest.assertEquals((int)2, (int)results.size());
        AttributeServiceTest.assertEquals((int)2, (int)counter.getValue());
    }

    public void testRemoveOrphanedProps() {
        String[] stringKey = new String[]{"z", "q", "string"};
        String[] doubleKey = new String[]{"z", "q", "double"};
        String[] dateKey = new String[]{"z", "q", "date"};
        this.attributeService.removeAttributes((Serializable[])stringKey);
        this.attributeService.removeAttributes((Serializable[])doubleKey);
        this.attributeService.removeAttributes((Serializable[])dateKey);
        PropValGenerator valueGen = new PropValGenerator(this.propertyValueDAO);
        String stringValue = valueGen.createUniqueString();
        this.attributeService.createAttribute((Serializable)((Object)stringValue), (Serializable[])stringKey);
        Double doubleValue = valueGen.createUniqueDouble();
        this.attributeService.createAttribute((Serializable)doubleValue, (Serializable[])doubleKey);
        Date dateValue = valueGen.createUniqueDate();
        this.attributeService.createAttribute((Serializable)dateValue, (Serializable[])dateKey);
        this.attributeService.removeAttributes((Serializable[])stringKey);
        this.attributeService.removeAttributes((Serializable[])doubleKey);
        this.attributeService.removeAttributes((Serializable[])dateKey);
        AttributeServiceTest.assertEquals((Object)stringValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)((Object)stringValue)).getSecond());
        AttributeServiceTest.assertEquals((Object)doubleValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)doubleValue).getSecond());
        AttributeServiceTest.assertEquals((Object)dateValue, (Object)this.propertyValueDAO.getPropertyValue((Serializable)dateValue).getSecond());
        this.propertyValueDAO.cleanupUnusedValues();
        this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)((Object)stringValue)));
        this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)doubleValue));
        this.assertPropDeleted(this.propertyValueDAO.getPropertyValue((Serializable)dateValue));
    }

    private void assertPropDeleted(Pair<Long, ?> value) {
        if (value != null) {
            String msg = String.format("Property value [%s=%s] should have been deleted by cleanup script.", value.getSecond().getClass().getSimpleName(), value.getSecond());
            AttributeServiceTest.fail((String)msg);
        }
    }

    public void testKeySegmentsGuaranteeUniqueness() {
        DefaultPropertyTypeConverter converter = new DefaultPropertyTypeConverter();
        TestIdentifier.TestEnum KEY_ENUM = TestIdentifier.TestEnum.ONE;
        HashMap KEY_MAP = new HashMap();
        NodeRef KEY_NODEREF = new NodeRef("workspace://SpacesStore/5980bbdb-8a31-437e-95c8-d5092c3c58fc");
        TestIdentifier KEY_SERIALIZABLE = new TestIdentifier("string2");
        try {
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum((Serializable)Integer.valueOf(2), (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.LONG);
            this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{Integer.valueOf(1), Integer.valueOf(2)});
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(1), new Serializable[]{Integer.valueOf(1), Integer.valueOf(2)});
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum((Serializable)KEY_NODEREF, (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.STRING);
            this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{Integer.valueOf(1), KEY_NODEREF});
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(1), new Serializable[]{Integer.valueOf(1), KEY_NODEREF});
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum((Serializable)((Object)KEY_ENUM), (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.ENUM);
            this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{Integer.valueOf(1), KEY_ENUM});
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(1), new Serializable[]{Integer.valueOf(1), KEY_ENUM});
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum(KEY_MAP, (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.CONSTRUCTABLE);
            this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{Integer.valueOf(1), KEY_MAP});
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(1), new Serializable[]{Integer.valueOf(1), KEY_MAP});
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum((Serializable)((Object)"string2"), (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.STRING);
            this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{"string", "string2"});
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(1), new Serializable[]{"string", "string2"});
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            AttributeServiceTest.assertEquals((Object)PropertyValueEntity.getPersistedTypeEnum((Serializable)KEY_SERIALIZABLE, (PropertyTypeConverter)converter), (Object)PropertyValueEntity.PersistedType.SERIALIZABLE);
            try {
                this.attributeService.createAttribute((Serializable)Integer.valueOf(0), new Serializable[]{"string", KEY_SERIALIZABLE});
                AttributeServiceTest.fail((String)"Keys of SERIALIZABLE persisted type are not allowed because it cannot guarantee uniqueness");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Throwable throwable) {
            this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), Integer.valueOf(2)});
            this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_NODEREF});
            this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_ENUM});
            this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_MAP});
            this.attributeService.removeAttribute(new Serializable[]{"string", "string2"});
            this.attributeService.removeAttribute(new Serializable[]{"string", KEY_SERIALIZABLE});
            this.propertyValueDAO.cleanupUnusedValues();
            throw throwable;
        }
        this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), Integer.valueOf(2)});
        this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_NODEREF});
        this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_ENUM});
        this.attributeService.removeAttribute(new Serializable[]{Integer.valueOf(1), KEY_MAP});
        this.attributeService.removeAttribute(new Serializable[]{"string", "string2"});
        this.attributeService.removeAttribute(new Serializable[]{"string", KEY_SERIALIZABLE});
        this.propertyValueDAO.cleanupUnusedValues();
    }

    public void testUpdateOrCreateAttribute() {
        String KEY_RND_STR_1 = "string1" + GUID.generate();
        String KEY_RND_STR_2 = "string2" + GUID.generate();
        try {
            this.attributeService.updateOrCreateAttribute((Serializable)((Object)KEY_RND_STR_2), null, null, (Serializable)((Object)KEY_RND_STR_1), null, null);
            try {
                this.attributeService.updateOrCreateAttribute((Serializable)((Object)KEY_RND_STR_2), null, null, (Serializable)((Object)KEY_RND_STR_1), null, null);
                AttributeServiceTest.fail((String)"Duplicate attribute creation should not be allowed");
            }
            catch (DuplicateAttributeException duplicateAttributeException) {}
            this.attributeService.updateOrCreateAttribute((Serializable)((Object)KEY_RND_STR_1), null, null, (Serializable)((Object)KEY_RND_STR_2), null, null);
            this.attributeService.updateOrCreateAttribute((Serializable)((Object)KEY_RND_STR_2), null, null, (Serializable)((Object)KEY_RND_STR_2), null, null);
        }
        catch (Throwable throwable) {
            this.attributeService.removeAttribute(new Serializable[]{KEY_RND_STR_1, null, null});
            this.attributeService.removeAttribute(new Serializable[]{KEY_RND_STR_2, null, null});
            throw throwable;
        }
        this.attributeService.removeAttribute(new Serializable[]{KEY_RND_STR_1, null, null});
        this.attributeService.removeAttribute(new Serializable[]{KEY_RND_STR_2, null, null});
    }
}

