/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.service.cmr.repository.NodeRef;

public class SwitchingTransformClient
implements TransformClient {
    private final TransformClient primary;
    private final TransformClient secondary;
    private ThreadLocal<TransformClient> transformClient = new ThreadLocal();

    public SwitchingTransformClient(TransformClient primary, TransformClient secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void checkSupported(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String sourceMimetype, long sourceSizeInBytes, String contentUrl) {
        try {
            this.primary.checkSupported(sourceNodeRef, renditionDefinition, sourceMimetype, sourceSizeInBytes, contentUrl);
            this.transformClient.set(this.primary);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                this.secondary.checkSupported(sourceNodeRef, renditionDefinition, sourceMimetype, sourceSizeInBytes, contentUrl);
                this.transformClient.set(this.secondary);
            }
            catch (UnsupportedOperationException e2) {
                this.transformClient.set(null);
                throw e2;
            }
        }
    }

    @Override
    public void transform(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String user, int sourceContentHashCode) {
        this.transformClient.get().transform(sourceNodeRef, renditionDefinition, user, sourceContentHashCode);
    }
}

