/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.lock;

import java.text.MessageFormat;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;

public class UnableToReleaseLockException
extends RuntimeException {
    private static final long serialVersionUID = 3257565088071432244L;
    private static final String ERROR_MESSAGE_1 = I18NUtil.getMessage((String)"lock_service.insufficent_privileges");
    private static final String ERROR_MESSAGE_2 = I18NUtil.getMessage((String)"lock_service.unlock_checkedout");

    public UnableToReleaseLockException(NodeRef nodeRef) {
        super(MessageFormat.format(ERROR_MESSAGE_1, nodeRef.getId()));
    }

    private static String createMessage(NodeRef nodeRef, CAUSE cause) {
        if (cause == null) {
            return MessageFormat.format(ERROR_MESSAGE_1, nodeRef.getId());
        }
        switch (cause) {
            case INSUFFICIENT: {
                return MessageFormat.format(ERROR_MESSAGE_1, nodeRef.getId());
            }
            case CHECKED_OUT: {
                return MessageFormat.format(ERROR_MESSAGE_2, nodeRef.getId());
            }
        }
        return MessageFormat.format(ERROR_MESSAGE_1, nodeRef.getId());
    }

    public UnableToReleaseLockException(NodeRef nodeRef, CAUSE cause) {
        super(UnableToReleaseLockException.createMessage(nodeRef, cause));
    }

    public static enum CAUSE {
        INSUFFICIENT,
        CHECKED_OUT;

    }
}

