/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.springframework.extensions.surf.util.I18NUtil;

public class DeprecatedModulesValidator {
    private static final String ERROR_MSG = "module.err.deprecated_modules";
    private final ModuleService moduleService;
    private final List<String> deprecatedModules;

    public DeprecatedModulesValidator(ModuleService moduleService, List<String> deprecatedModules) {
        this.moduleService = moduleService;
        this.deprecatedModules = deprecatedModules;
    }

    public void onInit() {
        Optional.ofNullable(this.moduleService.getAllModules()).map(this::getDeprecatedModules).filter(Predicate.not(String::isBlank)).ifPresent(DeprecatedModulesValidator::throwException);
    }

    private String getDeprecatedModules(List<ModuleDetails> modules) {
        return modules.stream().filter(module -> this.deprecatedModules.contains(module.getId())).map(module -> module.getTitle() + " " + String.valueOf(module.getModuleVersionNumber())).collect(Collectors.joining(", "));
    }

    private static void throwException(String foundDeprecatedModules) {
        throw new IllegalStateException(I18NUtil.getMessage((String)ERROR_MSG, (Object[])new Object[]{foundDeprecatedModules}));
    }
}

