/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.impl.model.ModelPermissionEntry;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class NodePermission
implements NodePermissionEntry,
XMLModelInitialisable {
    private static final String NODE_REF = "nodeRef";
    private static final String NODE_PERMISSION = "nodePermission";
    private static final String INHERIT_FROM_PARENT = "inheritFromParent";
    private NodeRef nodeRef;
    private List<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
    private boolean inheritPermissionsFromParent;

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public boolean inheritPermissions() {
        return this.inheritPermissionsFromParent;
    }

    public List<PermissionEntry> getPermissionEntries() {
        return Collections.unmodifiableList(this.permissionEntries);
    }

    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        Attribute inheritFromParentAttribute;
        Attribute nodeRefAttribute = element.attribute(NODE_REF);
        if (nodeRefAttribute != null) {
            this.nodeRef = new NodeRef(nodeRefAttribute.getStringValue());
        }
        this.inheritPermissionsFromParent = (inheritFromParentAttribute = element.attribute(INHERIT_FROM_PARENT)) != null ? Boolean.parseBoolean(inheritFromParentAttribute.getStringValue()) : true;
        Iterator npit = element.elementIterator(NODE_PERMISSION);
        while (npit.hasNext()) {
            Element permissionEntryElement = (Element)npit.next();
            ModelPermissionEntry permissionEntry = new ModelPermissionEntry(this.nodeRef);
            permissionEntry.initialise(permissionEntryElement, nspr, permissionModel);
            this.permissionEntries.add(permissionEntry);
        }
    }
}

