/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.Socket;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.email.server.EmailServer;
import org.alfresco.email.server.EmailServiceImpl;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class EmailServerTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private EmailServer emailServer;
    private final int DEFAULT_TEST_PORT = 2225;
    private final String TEST_HOST = "localhost";
    private final int TEST_CLIENT_TIMEOUT = 20000;
    private final short SHUTDOWN_SLEEP_TIME = (short)1000;
    private EmailService emailService;
    private int currentPort;

    @Before
    public void setUp() throws Exception {
        ChildApplicationContextFactory emailSubsystem = (ChildApplicationContextFactory)ctx.getBean("InboundSMTP");
        EmailServerTest.assertNotNull((String)"emailSubsystem", (Object)emailSubsystem);
        ApplicationContext emailCtx = emailSubsystem.getApplicationContext();
        this.emailServer = (EmailServer)emailCtx.getBean("emailServer");
        this.emailService = (EmailService)emailCtx.getBean("emailService");
        EmailServerTest.assertNotNull((String)"emailService", (Object)this.emailService);
        this.shutdownServer();
    }

    @After
    public void tearDown() throws Exception {
        this.shutdownServer();
    }

    @Test
    public void testDisallowedNulableFromUser() throws Exception {
        this.emailServer.setEnableTLS(false);
        this.emailServer.setAuthenticate(false);
        this.emailServer.setUnknownUser(null);
        this.startupServer();
        String[] response = this.getMailFromNullableResponse("localhost", this.getServerPort());
        this.checkResponse(response);
        EmailServerTest.assertTrue((String)"Response should have error code", (response[1].indexOf("5") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllowedNulableFromUserWithAuth() throws Exception {
        this.emailServer.setEnableTLS(false);
        this.emailServer.setAuthenticate(true);
        this.emailServer.setUnknownUser(null);
        this.startupServer();
        String[] response = this.getMailFromNullableResponse("localhost", this.getServerPort());
        this.checkResponse(response);
        EmailServerTest.assertTrue((String)"Response should have error code", (response[1].indexOf("2") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllowedNulableFromUserWithAnonymous() throws Exception {
        this.emailServer.setEnableTLS(false);
        this.emailServer.setAuthenticate(false);
        this.emailServer.setUnknownUser("anonymous");
        this.startupServer();
        String[] response = this.getMailFromNullableResponse("localhost", this.getServerPort());
        this.checkResponse(response);
        EmailServerTest.assertTrue((String)"Response should have error code", (response[1].indexOf("2") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testForDataAcceptingIfUserIsEmpty() throws Exception {
        if (this.emailService instanceof EmailServiceImpl) {
            ((EmailServiceImpl)this.emailService).setUnknownUser("");
        }
        this.emailServer.setUnknownUser(null);
        this.emailServer.setAuthenticate(true);
        this.emailServer.setEnableTLS(false);
        this.startupServer();
        String[] request = new String[]{"MAIL FROM:<>\r\n", "RCPT TO:<buffy@sunnydale.high>\r\n", "DATA\r\n", "Hello world\r\n.\r\n", "QUIT\r\n"};
        String[] response = this.getResponse("localhost", this.getServerPort(), request);
        this.checkResponse(response);
        EmailServerTest.assertTrue((String)"Response incorrect", (response.length > 4 ? 1 : 0) != 0);
        EmailServerTest.assertTrue((String)"Response should have error code", (response[4].indexOf("5") == 0 ? 1 : 0) != 0);
    }

    private void startupServer() {
        this.currentPort = 2225;
        boolean started = false;
        while (!started && this.currentPort < 65535) {
            try {
                this.emailServer.setEnabled(true);
                this.emailServer.setPort(this.currentPort);
                this.emailServer.onBootstrap(null);
                started = true;
            }
            catch (Exception exc) {
                if (exc.getCause() instanceof BindException) {
                    ++this.currentPort;
                    continue;
                }
                throw exc;
            }
        }
        if (!started) {
            throw new RuntimeException("Unable to start email server");
        }
    }

    private void shutdownServer() throws InterruptedException {
        this.emailServer.onShutdown(null);
        Thread.sleep(1000L);
        this.emailServer.setEnabled(false);
    }

    private int getServerPort() {
        return this.currentPort;
    }

    private void checkResponse(String[] response) {
        EmailServerTest.assertNotNull((String)"Client hasn't response", (Object)response);
        EmailServerTest.assertNotNull((String)"Client hasn empty response", (Object)response[0]);
    }

    private String[] getMailFromNullableResponse(String host, int port) throws Exception {
        return this.getResponse(host, port, new String[]{"MAIL FROM:<>\r\n", "QUIT\r\n"});
    }

    private String[] getResponse(String host, int port, String[] requestStrings) throws Exception {
        Socket sock = new Socket(host, port);
        sock.setSoTimeout(20000);
        PrintWriter out = new PrintWriter(sock.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        ArrayList<String> response = new ArrayList<String>();
        try {
            response.add(in.readLine());
            String[] stringArray = requestStrings;
            int n = requestStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String reqStr = stringArray[n2];
                out.print(reqStr);
                out.flush();
                response.add(in.readLine());
                ++n2;
            }
            String[] stringArray2 = response.toArray(new String[response.size()]);
            return stringArray2;
        }
        finally {
            in.close();
            out.close();
            sock.close();
        }
    }
}

