/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class Log4JHierarchyInit
implements ApplicationContextAware {
    private static final Log LOGGER = LogFactory.getLog(Log4JHierarchyInit.class);
    private final List<String> extraLog4jUrls;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    static {
        System.setProperty("log4j2.disableJmx", "false");
    }

    public Log4JHierarchyInit() {
        this.extraLog4jUrls = new ArrayList<String>();
    }

    public void setExtraLog4jUrls(List<String> urls) {
        this.extraLog4jUrls.addAll(urls);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    public void init() {
        this.importLogSettings();
    }

    private void importLogSettings() {
        block3: {
            try {
                Properties mainProperties = new Properties();
                Log4JHierarchyInit.importMainLogSettings(mainProperties);
                for (String url : this.extraLog4jUrls) {
                    this.importLogSettings(url, mainProperties);
                }
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfigurationBuilder().setConfigurationSource(null).setRootProperties(mainProperties).setLoggerContext((LoggerContext)LogManager.getContext((boolean)false)).build();
                propertiesConfiguration.initialize();
                ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure((Configuration)propertiesConfiguration);
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)("Failed to add extra Logger configuration: \n   Error: " + t.getMessage()), t);
            }
        }
    }

    private static void importMainLogSettings(Properties mainProperties) throws IOException {
        block12: {
            File file = ((LoggerContext)LogManager.getContext()).getConfiguration().getConfigurationSource().getFile();
            if (file != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        mainProperties.load(fis);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    if (!LOGGER.isDebugEnabled()) break block12;
                    LOGGER.debug((Object)("Failed to find initial configuration: \n   Error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void importLogSettings(String springUrl, Properties mainProperties) {
        Resource[] resources = null;
        try {
            resources = this.resolver.getResources(springUrl);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Failed to find additional Logger configuration: " + springUrl));
        }
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Resource resource = resourceArray[n2];
                try {
                    InputStream inputStream = resource.getInputStream();
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    mainProperties.putAll((Map<?, ?>)properties);
                }
                catch (Throwable e) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug((Object)("Failed to add extra Logger configuration: \n   URL:   " + springUrl + "\n   Error: " + e.getMessage()), e);
                }
            }
            ++n2;
        }
    }
}

