/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class LatLonPointSpatialField
extends AbstractSpatialFieldType
implements SchemaAware {
    private IndexSchema schema;

    @Override
    protected void checkSupportsDocValues() {
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
    }

    protected SpatialStrategy newSpatialStrategy(String fieldName) {
        SchemaField schemaField = this.schema.getField(fieldName);
        return new LatLonPointSpatialStrategy(this.ctx, fieldName, schemaField.indexed(), schemaField.hasDocValues());
    }

    public static class LatLonPointSpatialStrategy
    extends SpatialStrategy {
        private final boolean indexed;
        private final boolean docValues;

        public LatLonPointSpatialStrategy(SpatialContext ctx, String fieldName, boolean indexed, boolean docValues) {
            super(ctx, fieldName);
            if (!ctx.isGeo()) {
                throw new IllegalArgumentException("ctx must be geo=true: " + ctx);
            }
            this.indexed = indexed;
            this.docValues = docValues;
        }

        public Field[] createIndexableFields(Shape shape) {
            if (!(shape instanceof Point)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ((Object)((Object)this)).getClass().getSimpleName() + " only supports indexing points; got: " + shape);
            }
            Point point = (Point)shape;
            int fieldsLen = (this.indexed ? 1 : 0) + (this.docValues ? 1 : 0);
            Field[] fields = new Field[fieldsLen];
            int fieldsIdx = 0;
            if (this.indexed) {
                fields[fieldsIdx++] = new LatLonPoint(this.getFieldName(), point.getY(), point.getX());
            }
            if (this.docValues) {
                fields[fieldsIdx++] = new LatLonDocValuesField(this.getFieldName(), point.getY(), point.getX());
            }
            return fields;
        }

        public Query makeQuery(SpatialArgs args) {
            if (args.getOperation() != SpatialOperation.Intersects) {
                throw new UnsupportedSpatialOperation(args.getOperation());
            }
            Shape shape = args.getShape();
            if (this.indexed && this.docValues) {
                return new IndexOrDocValuesQuery(this.makeQueryFromIndex(shape), this.makeQueryFromDocValues(shape));
            }
            if (this.indexed) {
                return this.makeQueryFromIndex(shape);
            }
            if (this.docValues) {
                return this.makeQueryFromDocValues(shape);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getFieldName() + " needs indexed (preferred) or docValues to support search");
        }

        protected Query makeQueryFromIndex(Shape shape) {
            if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                double radiusMeters = circle.getRadius() * 111.19507973436875 * 1000.0;
                return LatLonPoint.newDistanceQuery((String)this.getFieldName(), (double)circle.getCenter().getY(), (double)circle.getCenter().getX(), (double)radiusMeters);
            }
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                return LatLonPoint.newBoxQuery((String)this.getFieldName(), (double)rect.getMinY(), (double)rect.getMaxY(), (double)rect.getMinX(), (double)rect.getMaxX());
            }
            if (shape instanceof Point) {
                Point point = (Point)shape;
                return LatLonPoint.newDistanceQuery((String)this.getFieldName(), (double)point.getY(), (double)point.getX(), (double)0.0);
            }
            throw new UnsupportedOperationException("Shape " + shape.getClass() + " is not supported by " + ((Object)((Object)this)).getClass());
        }

        protected Query makeQueryFromDocValues(Shape shape) {
            if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                double radiusMeters = circle.getRadius() * 111.19507973436875 * 1000.0;
                return LatLonDocValuesField.newDistanceQuery((String)this.getFieldName(), (double)circle.getCenter().getY(), (double)circle.getCenter().getX(), (double)radiusMeters);
            }
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                return LatLonDocValuesField.newBoxQuery((String)this.getFieldName(), (double)rect.getMinY(), (double)rect.getMaxY(), (double)rect.getMinX(), (double)rect.getMaxX());
            }
            if (shape instanceof Point) {
                Point point = (Point)shape;
                return LatLonDocValuesField.newDistanceQuery((String)this.getFieldName(), (double)point.getY(), (double)point.getX(), (double)0.0);
            }
            throw new UnsupportedOperationException("Shape " + shape.getClass() + " is not supported by " + ((Object)((Object)this)).getClass());
        }

        public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
            if (!this.docValues) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getFieldName() + " must have docValues enabled to support this feature");
            }
            return new DistanceSortValueSource(this.getFieldName(), queryPoint, 8.993203677616634E-6 * multiplier);
        }

        private static class DistanceSortValueSource
        extends ValueSource {
            private final String fieldName;
            private final Point queryPoint;
            private final double multiplier;

            DistanceSortValueSource(String fieldName, Point queryPoint, double multiplier) {
                this.fieldName = fieldName;
                this.queryPoint = queryPoint;
                this.multiplier = multiplier;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                DistanceSortValueSource that = (DistanceSortValueSource)((Object)o);
                return Double.compare(that.multiplier, this.multiplier) == 0 && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.queryPoint, that.queryPoint);
            }

            public int hashCode() {
                return Objects.hash(this.fieldName, this.queryPoint, this.multiplier);
            }

            public FunctionValues getValues(Map context, final LeafReaderContext readerContext) throws IOException {
                return new DoubleDocValues(this){
                    final FieldComparator<Double> comparator;
                    final LeafFieldComparator leafComparator;
                    final double mult;
                    double cacheDoc;
                    double cacheVal;
                    {
                        super(arg0);
                        this.comparator = this.getSortField(false).getComparator(1, 1);
                        this.leafComparator = this.comparator.getLeafComparator(readerContext);
                        this.mult = multiplier;
                        this.cacheDoc = -1.0;
                        this.cacheVal = Double.POSITIVE_INFINITY;
                    }

                    public double doubleVal(int doc) {
                        if (this.cacheDoc != (double)doc) {
                            try {
                                this.leafComparator.copy(0, doc);
                                this.cacheVal = (Double)this.comparator.value(0) * this.mult;
                                this.cacheDoc = doc;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.cacheVal;
                    }

                    public boolean exists(int doc) {
                        return !Double.isInfinite(this.doubleVal(doc));
                    }
                };
            }

            public String description() {
                return "distSort(" + this.fieldName + ", " + this.queryPoint + ", mult:" + this.multiplier + ")";
            }

            public SortField getSortField(boolean reverse) {
                if (reverse) {
                    return super.getSortField(true);
                }
                return LatLonDocValuesField.newDistanceSort((String)this.fieldName, (double)this.queryPoint.getY(), (double)this.queryPoint.getX());
            }
        }
    }
}

