/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRange;
import org.apache.solr.search.facet.FacetRequestSortedMerger;

public class FacetRangeMerger
extends FacetRequestSortedMerger<FacetRange> {
    FacetBucket beforeBucket;
    FacetBucket afterBucket;
    FacetBucket betweenBucket;

    public FacetRangeMerger(FacetRange freq) {
        super(freq);
    }

    @Override
    FacetMerger createFacetMerger(String key, Object val) {
        return super.createFacetMerger(key, val);
    }

    @Override
    public void merge(Object facetResult, FacetMerger.Context mcontext) {
        this.merge((SimpleOrderedMap)facetResult, mcontext);
    }

    @Override
    public void sortBuckets() {
        this.sortedBuckets = new ArrayList(this.buckets.values());
    }

    @Override
    public void finish(FacetMerger.Context mcontext) {
    }

    public void merge(SimpleOrderedMap facetResult, FacetMerger.Context mcontext) {
        Object o;
        boolean all = ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.ALL);
        if ((all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BEFORE)) && (o = facetResult.get("before")) != null) {
            if (this.beforeBucket == null) {
                this.beforeBucket = this.newBucket(null, mcontext);
            }
            this.beforeBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if ((all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.AFTER)) && (o = facetResult.get("after")) != null) {
            if (this.afterBucket == null) {
                this.afterBucket = this.newBucket(null, mcontext);
            }
            this.afterBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if ((all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BETWEEN)) && (o = facetResult.get("between")) != null) {
            if (this.betweenBucket == null) {
                this.betweenBucket = this.newBucket(null, mcontext);
            }
            this.betweenBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        List bucketList = (List)facetResult.get("buckets");
        this.mergeBucketList(bucketList, mcontext);
    }

    @Override
    public Object getMergedResult() {
        SimpleOrderedMap result = new SimpleOrderedMap(4);
        ArrayList<SimpleOrderedMap> resultBuckets = new ArrayList<SimpleOrderedMap>(this.buckets.size());
        for (FacetBucket bucket : this.buckets.values()) {
            if (bucket.getCount() < ((FacetRange)this.freq).mincount) continue;
            resultBuckets.add(bucket.getMergedBucket());
        }
        result.add("buckets", resultBuckets);
        if (this.beforeBucket != null) {
            result.add("before", (Object)this.beforeBucket.getMergedBucket());
        }
        if (this.afterBucket != null) {
            result.add("after", (Object)this.afterBucket.getMergedBucket());
        }
        if (this.betweenBucket != null) {
            result.add("between", (Object)this.betweenBucket.getMergedBucket());
        }
        return result;
    }
}

