/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.UniqueSlotAcc;

class UniqueSinglevaluedSlotAcc
extends UniqueSlotAcc {
    SortedDocValues topLevel;
    SortedDocValues[] subDvs;
    MultiDocValues.OrdinalMap ordMap;
    LongValues toGlobal;
    SortedDocValues subDv;

    public UniqueSinglevaluedSlotAcc(FacetContext fcontext, SchemaField field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext, field, numSlots, factory);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        SolrIndexSearcher searcher = this.fcontext.qcontext.searcher();
        this.topLevel = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.field, null);
        this.nTerms = this.topLevel.getValueCount();
        if (this.topLevel instanceof MultiDocValues.MultiSortedDocValues) {
            this.ordMap = ((MultiDocValues.MultiSortedDocValues)this.topLevel).mapping;
            this.subDvs = ((MultiDocValues.MultiSortedDocValues)this.topLevel).values;
        } else {
            this.ordMap = null;
            this.subDvs = null;
        }
    }

    @Override
    protected BytesRef lookupOrd(int ord) {
        return this.topLevel.lookupOrd(ord);
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        if (this.topLevel == null) {
            this.reset();
        }
        super.setNextReader(readerContext);
        if (this.subDvs != null) {
            this.subDv = this.subDvs[readerContext.ord];
            this.toGlobal = this.ordMap.getGlobalOrds(readerContext.ord);
        } else {
            assert (readerContext.ord == 0 || this.topLevel.getValueCount() == 0);
            this.subDv = this.topLevel;
        }
    }

    @Override
    public void collect(int doc, int slotNum) {
        int segOrd = this.subDv.getOrd(doc);
        if (segOrd < 0) {
            return;
        }
        int ord = this.toGlobal == null ? segOrd : (int)this.toGlobal.get(segOrd);
        FixedBitSet bits = this.arr[slotNum];
        if (bits == null) {
            this.arr[slotNum] = bits = new FixedBitSet(this.nTerms);
        }
        bits.set(ord);
    }
}

