/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.LanguageCode;
import org.carrot2.shaded.guava.common.base.Function;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.shaded.guava.common.collect.Ordering;
import org.carrot2.shaded.guava.common.collect.Sets;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;

@Root(name="document")
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Document
implements Cloneable {
    public static final String TITLE = "title";
    public static final String SUMMARY = "snippet";
    public static final String CONTENT_URL = "url";
    public static final String CLICK_URL = "click-url";
    public static final String THUMBNAIL_URL = "thumbnail-url";
    public static final String SIZE = "size";
    public static final String SCORE = "score";
    public static final String SOURCES = "sources";
    public static final String LANGUAGE = "language";
    public static final String PARTITIONS = "partitions";
    private final Map<String, Object> fields = Maps.newHashMap();
    private final Map<String, Object> fieldsView = Collections.unmodifiableMap(this.fields);
    @Attribute(required=false)
    String id;
    private ArrayList<IDocumentSerializationListener> serializationListeners;
    public static final Comparator<Document> BY_ID_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)DocumentToId.INSTANCE);

    public Document() {
    }

    public Document(String title) {
        this(title, null);
    }

    public Document(String title, String summary) {
        this(title, summary, (String)null);
    }

    public Document(String title, String summary, LanguageCode language) {
        this(title, summary, null, language);
    }

    public Document(String title, String summary, String contentUrl) {
        this(title, summary, contentUrl, null);
    }

    public Document(String title, String summary, String contentUrl, LanguageCode language) {
        this.setField(TITLE, title);
        this.setField(SUMMARY, summary);
        if (StringUtils.isNotBlank((String)contentUrl)) {
            this.setField(CONTENT_URL, contentUrl);
        }
        if (language != null) {
            this.setField(LANGUAGE, (Object)language);
        }
    }

    public Document(String title, String summary, String contentUrl, LanguageCode language, String id) {
        this(title, summary, contentUrl, language);
        this.id = id;
    }

    public Integer getId() {
        try {
            return this.id != null ? Integer.valueOf(Integer.parseInt(this.id)) : null;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Could not parse document identifier as an integer: " + this.id);
        }
    }

    @JsonProperty(value="id")
    public String getStringId() {
        return this.id;
    }

    @JsonProperty
    @Element(required=false)
    public String getTitle() {
        return (String)this.getField(TITLE);
    }

    @Element(required=false)
    public Document setTitle(String title) {
        return this.setField(TITLE, title);
    }

    @JsonProperty(value="snippet")
    @Element(name="snippet", required=false)
    public String getSummary() {
        return (String)this.getField(SUMMARY);
    }

    @Element(name="snippet", required=false)
    public Document setSummary(String summary) {
        return this.setField(SUMMARY, summary);
    }

    @JsonProperty(value="url")
    @Element(name="url", required=false)
    public String getContentUrl() {
        return (String)this.getField(CONTENT_URL);
    }

    @Element(name="url", required=false)
    public Document setContentUrl(String contentUrl) {
        return this.setField(CONTENT_URL, contentUrl);
    }

    @JsonProperty
    @ElementList(entry="source", required=false)
    public List<String> getSources() {
        return (List)this.getField(SOURCES);
    }

    @ElementList(entry="source", required=false)
    public Document setSources(List<String> sources) {
        return this.setField(SOURCES, sources);
    }

    public LanguageCode getLanguage() {
        return (LanguageCode)((Object)this.getField(LANGUAGE));
    }

    public Document setLanguage(LanguageCode language) {
        return this.setField(LANGUAGE, (Object)language);
    }

    @Attribute(name="score", required=false)
    public Double getScore() {
        return (Double)this.getField(SCORE);
    }

    @Attribute(name="score", required=false)
    public Document setScore(Double score) {
        return this.setField(SCORE, score);
    }

    @JsonProperty(value="language")
    @Attribute(required=false, name="language")
    private String getLanguageIsoCode() {
        LanguageCode language = this.getLanguage();
        return language != null ? language.getIsoCode() : null;
    }

    @Attribute(required=false, name="language")
    private void setLanguageIsoCode(String languageIsoCode) {
        if (languageIsoCode != null) {
            LanguageCode language = LanguageCode.forISOCode(languageIsoCode);
            if (language != null) {
                this.setLanguage(language);
            } else {
                this.setLanguage(LanguageCode.valueOf(languageIsoCode));
            }
        } else {
            this.setLanguage(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonProperty(value="fields")
    private Map<String, Object> getOtherFields() {
        HashMap otherFields;
        Document document = this;
        synchronized (document) {
            otherFields = Maps.newHashMap(this.fields);
        }
        otherFields.remove(TITLE);
        otherFields.remove(SUMMARY);
        otherFields.remove(CONTENT_URL);
        otherFields.remove(SOURCES);
        otherFields.remove(LANGUAGE);
        otherFields.remove(SCORE);
        this.fireSerializationListeners(otherFields);
        return otherFields.isEmpty() ? null : otherFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> getOtherFieldsXml() {
        HashMap<String, SimpleXmlWrapperValue> otherFieldsForSerialization;
        Document document = this;
        synchronized (document) {
            otherFieldsForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.fields));
        }
        otherFieldsForSerialization.remove(TITLE);
        otherFieldsForSerialization.remove(SUMMARY);
        otherFieldsForSerialization.remove(CONTENT_URL);
        otherFieldsForSerialization.remove(SOURCES);
        otherFieldsForSerialization.remove(LANGUAGE);
        otherFieldsForSerialization.remove(SCORE);
        this.fireSerializationListeners(otherFieldsForSerialization);
        return otherFieldsForSerialization.isEmpty() ? null : otherFieldsForSerialization;
    }

    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private void setOtherFieldsXml(HashMap<String, SimpleXmlWrapperValue> otherFieldsForSerialization) {
        if (otherFieldsForSerialization != null) {
            this.fields.putAll(SimpleXmlWrappers.unwrap(otherFieldsForSerialization));
        }
    }

    public Map<String, Object> getFields() {
        return this.fieldsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getField(String name) {
        Document document = this;
        synchronized (document) {
            return (T)this.fields.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setField(String name, Object value) {
        Document document = this;
        synchronized (document) {
            this.fields.put(name, value);
        }
        return this;
    }

    public Document clone() {
        Document clone = new Document();
        clone.id = this.id;
        clone.fields.putAll(this.fields);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignDocumentIds(Collection<Document> documents) {
        Collection<Document> collection = documents;
        synchronized (collection) {
            boolean hadIds = false;
            for (Document document : documents) {
                if (document.id == null) continue;
                hadIds = true;
                break;
            }
            if (hadIds) {
                HashSet ids = Sets.newHashSet();
                for (Document doc : documents) {
                    String id = doc.getStringId();
                    if (ids.add(id) || id == null) continue;
                    throw new IllegalArgumentException("Identifiers must be unique, duplicated identifier: " + id + " [existing: " + ids.toString() + "]");
                }
                if (ids.contains(null)) {
                    throw new IllegalArgumentException("Null identifiers cannot be mixed with existing non-null identifiers:  [existing: " + ids.toString() + "]");
                }
            } else {
                int id = 0;
                for (Document document : documents) {
                    document.id = Integer.toString(id);
                    ++id;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerializationListener(IDocumentSerializationListener listener) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners == null) {
                this.serializationListeners = Lists.newArrayList();
            }
            this.serializationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerializationListeners(Map<String, ?> otherFieldsForSerialization) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners != null) {
                for (IDocumentSerializationListener listener : this.serializationListeners) {
                    listener.beforeSerialization(this, otherFieldsForSerialization);
                }
            }
        }
    }

    public static interface IDocumentSerializationListener {
        public void beforeSerialization(Document var1, Map<String, ?> var2);
    }

    public static final class DocumentToId
    implements Function<Document, Integer> {
        public static final DocumentToId INSTANCE = new DocumentToId();

        private DocumentToId() {
        }

        public Integer apply(Document document) {
            return document.getId();
        }
    }
}

