/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.solr.AlfrescoAnalyzerWrapper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.QueryBuilder;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class AlfrescoFieldType
extends FieldType {
    IndexSchema schema;

    protected void init(IndexSchema schema, Map<String, String> args) {
        this.schema = schema;
        this.properties |= 2;
        this.properties &= 0xFFFFFFDF;
        super.init(schema, args);
        this.setIndexAnalyzer((Analyzer)new AlfrescoAnalyzerWrapper(schema, AlfrescoAnalyzerWrapper.Mode.INDEX));
        this.setQueryAnalyzer((Analyzer)new AlfrescoAnalyzerWrapper(schema, AlfrescoAnalyzerWrapper.Mode.QUERY));
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return AlfrescoFieldType.parseFieldQuery(parser, this.getQueryAnalyzer(), field.getName(), externalVal);
    }

    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        Analyzer multiAnalyzer = this.constructMultiTermAnalyzer(this.getQueryAnalyzer());
        BytesRef lower = AlfrescoFieldType.analyzeMultiTerm(field.getName(), part1, multiAnalyzer);
        BytesRef upper = AlfrescoFieldType.analyzeMultiTerm(field.getName(), part2, multiAnalyzer);
        return new TermRangeQuery(field.getName(), lower, upper, minInclusive, maxInclusive);
    }

    private Analyzer constructMultiTermAnalyzer(Analyzer queryAnalyzer) {
        if (queryAnalyzer == null) {
            return null;
        }
        if (!(queryAnalyzer instanceof TokenizerChain)) {
            return new KeywordAnalyzer();
        }
        TokenizerChain tc = (TokenizerChain)queryAnalyzer;
        MultiTermChainBuilder builder = new MultiTermChainBuilder();
        CharFilterFactory[] charFactories = tc.getCharFilterFactories();
        if (charFactories != null) {
            for (CharFilterFactory charFilterFactory : charFactories) {
                builder.add(charFilterFactory);
            }
        }
        builder.add(tc.getTokenizerFactory());
        for (CharFilterFactory charFilterFactory : tc.getTokenFilterFactories()) {
            builder.add(charFilterFactory);
        }
        return builder.build();
    }

    public static BytesRef analyzeMultiTerm(String field, String part, Analyzer analyzerIn) {
        BytesRef bytesRef;
        if (part == null || analyzerIn == null) {
            return null;
        }
        TokenStream source = null;
        try {
            source = analyzerIn.tokenStream(field, part);
            source.reset();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            if (!source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned no terms for multiTerm term: " + part);
            }
            if (source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned too many terms for multiTerm term: " + part);
            }
            source.end();
            bytesRef = BytesRef.deepCopyOf((BytesRef)bytes);
        }
        catch (IOException e) {
            try {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error analyzing range part: " + part, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
        return bytesRef;
    }

    static Query parseFieldQuery(QParser parser, Analyzer analyzer, String field, String queryText) {
        return new QueryBuilder(analyzer).createPhraseQuery(field, queryText);
    }

    public Object marshalSortValue(Object value) {
        return AlfrescoFieldType.marshalStringSortValue((Object)value);
    }

    public Object unmarshalSortValue(Object value) {
        return AlfrescoFieldType.unmarshalStringSortValue((Object)value);
    }

    protected boolean supportsAnalyzers() {
        return true;
    }

    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return UninvertingReader.Type.SORTED_SET_BINARY;
    }

    private static class MultiTermChainBuilder {
        static final KeywordTokenizerFactory keyFactory = new KeywordTokenizerFactory(new HashMap());
        ArrayList<CharFilterFactory> charFilters = null;
        ArrayList<TokenFilterFactory> filters = new ArrayList(2);
        TokenizerFactory tokenizer = keyFactory;

        private MultiTermChainBuilder() {
        }

        public void add(Object current) {
            if (!(current instanceof MultiTermAwareComponent)) {
                return;
            }
            AbstractAnalysisFactory newComponent = ((MultiTermAwareComponent)current).getMultiTermComponent();
            if (newComponent instanceof TokenFilterFactory) {
                if (this.filters == null) {
                    this.filters = new ArrayList(2);
                }
                this.filters.add((TokenFilterFactory)newComponent);
            } else if (newComponent instanceof TokenizerFactory) {
                this.tokenizer = (TokenizerFactory)newComponent;
            } else if (newComponent instanceof CharFilterFactory) {
                if (this.charFilters == null) {
                    this.charFilters = new ArrayList(1);
                }
                this.charFilters.add((CharFilterFactory)newComponent);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown analysis component from MultiTermAwareComponent: " + String.valueOf(newComponent));
            }
        }

        public TokenizerChain build() {
            CharFilterFactory[] charFilterArr = this.charFilters == null ? null : this.charFilters.toArray(new CharFilterFactory[this.charFilters.size()]);
            TokenFilterFactory[] filterArr = this.filters == null ? new TokenFilterFactory[]{} : this.filters.toArray(new TokenFilterFactory[this.filters.size()]);
            return new TokenizerChain(charFilterArr, this.tokenizer, filterArr);
        }
    }
}

