/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.tracker.MetadataTracker;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyComponent
extends SearchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public void finishStage(ResponseBuilder rb) {
        super.finishStage(rb);
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        try {
            this.process(rb);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        AlfrescoCoreAdminHandler adminHandler = (AlfrescoCoreAdminHandler)req.getCore().getCoreContainer().getMultiCoreHandler();
        boolean isShard = rb.req.getParams().getBool("isShard", false);
        MetadataTracker metaTrkr = adminHandler.getTrackerRegistry().getTrackerForCore(req.getCore().getName(), MetadataTracker.class);
        if (metaTrkr != null && !isShard) {
            TrackerState metadataTrkrState = metaTrkr.getTrackerState();
            long lastIndexedTx = metadataTrkrState.getLastIndexedTxId();
            long lastIndexTxCommitTime = metadataTrkrState.getLastIndexedTxCommitTime();
            long lastTxIdOnServer = metadataTrkrState.getLastTxIdOnServer();
            long transactionsToDo = lastTxIdOnServer - lastIndexedTx;
            if (transactionsToDo < 0L) {
                transactionsToDo = 0L;
            }
            rb.rsp.add("lastIndexedTx", (Object)lastIndexedTx);
            rb.rsp.add("lastIndexedTxTime", (Object)lastIndexTxCommitTime);
            rb.rsp.add("txRemaining", (Object)transactionsToDo);
        }
    }

    public String getDescription() {
        return "Adds consitency information to the search results.";
    }
}

