/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.WrappedQuery;

public class SolrOwnerSetScorer
extends AbstractSolrCachingScorer {
    SolrOwnerSetScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrOwnerSetScorer createOwnerSetScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authorities) throws IOException {
        DocSet authorityOwnedDocs = (DocSet)searcher.cacheLookup("alfrescoOwnerCache", (Object)authorities);
        if (authorityOwnedDocs == null) {
            String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            for (String current : auths) {
                if (AuthorityType.getAuthorityType((String)current) != AuthorityType.USER) continue;
                bQuery.add((Query)new TermQuery(new Term("OWNER", current)), BooleanClause.Occur.SHOULD);
            }
            WrappedQuery wrapped = new WrappedQuery((Query)bQuery.build());
            wrapped.setCache(false);
            authorityOwnedDocs = searcher.getDocSet((Query)wrapped);
            searcher.cacheInsert("alfrescoOwnerCache", (Object)authorities, (Object)authorityOwnedDocs);
        }
        return new SolrOwnerSetScorer(weight, authorityOwnedDocs, context, searcher);
    }
}

