/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;

public abstract class AbstractCannedQuery<R>
implements CannedQuery<R> {
    private final CannedQueryParameters parameters;
    private final String queryExecutionId;
    private CannedQueryResults<R> results;

    protected AbstractCannedQuery(CannedQueryParameters parameters) {
        ParameterCheck.mandatory("parameters", parameters);
        this.parameters = parameters;
        this.queryExecutionId = GUID.generate();
    }

    @Override
    public CannedQueryParameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "AbstractCannedQuery [parameters=" + this.parameters + ", class=" + this.getClass() + "]";
    }

    @Override
    public final synchronized CannedQueryResults<R> execute() {
        if (this.results != null) {
            throw new IllegalStateException("This query instance has already by used.  It can only be used to query once.");
        }
        List<R> rawResults = this.queryAndFilter(this.parameters);
        if (rawResults == null) {
            throw new AlfrescoRuntimeException("Execution returned 'null' results");
        }
        if (this.isApplyPostQuerySorting()) {
            rawResults = this.applyPostQuerySorting(rawResults, this.parameters.getSortDetails());
        }
        if (this.isApplyPostQueryPermissions()) {
            int requestedCount = this.parameters.getResultsRequired();
            rawResults = this.applyPostQueryPermissions(rawResults, requestedCount);
        }
        final Pair<Integer, Integer> totalCount = this.getTotalResultCount(rawResults);
        CannedQueryPageDetails pagingDetails = this.parameters.getPageDetails();
        List<List<R>> pages = Collections.singletonList(rawResults);
        if (this.isApplyPostQueryPaging()) {
            pages = this.applyPostQueryPaging(rawResults, pagingDetails);
        }
        final List<List<R>> finalPages = pages;
        final boolean hasMoreItems = rawResults.size() > pagingDetails.getResultsRequiredForPaging() || totalCount.getFirst() > pagingDetails.getResultsRequiredForPaging();
        this.results = new CannedQueryResults<R>(){

            @Override
            public CannedQuery<R> getOriginatingQuery() {
                return AbstractCannedQuery.this;
            }

            @Override
            public String getQueryExecutionId() {
                return AbstractCannedQuery.this.queryExecutionId;
            }

            @Override
            public Pair<Integer, Integer> getTotalResultCount() {
                if (AbstractCannedQuery.this.parameters.getTotalResultCountMax() > 0) {
                    return totalCount;
                }
                throw new IllegalStateException("Total results were not requested in parameters.");
            }

            @Override
            public int getPagedResultCount() {
                int finalPagedCount = 0;
                for (List page : finalPages) {
                    finalPagedCount += page.size();
                }
                return finalPagedCount;
            }

            @Override
            public int getPageCount() {
                return finalPages.size();
            }

            @Override
            public R getSingleResult() {
                if (finalPages.size() != 1 && ((List)finalPages.get(0)).size() != 1) {
                    throw new IllegalStateException("There must be exactly one page of one result available.");
                }
                return ((List)finalPages.get(0)).get(0);
            }

            @Override
            public List<R> getPage() {
                if (finalPages.size() != 1) {
                    throw new IllegalStateException("There must be exactly one page of results available.");
                }
                return (List)finalPages.get(0);
            }

            @Override
            public List<List<R>> getPages() {
                return finalPages;
            }

            @Override
            public boolean hasMoreItems() {
                return hasMoreItems;
            }
        };
        return this.results;
    }

    protected abstract List<R> queryAndFilter(CannedQueryParameters var1);

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    protected List<R> applyPostQuerySorting(List<R> results, CannedQuerySortDetails sortDetails) {
        throw new UnsupportedOperationException("Override this method if post-query sorting is required.");
    }

    protected boolean isApplyPostQueryPermissions() {
        return false;
    }

    protected List<R> applyPostQueryPermissions(List<R> results, int requestedCount) {
        throw new UnsupportedOperationException("Override this method if post-query filtering is required.");
    }

    protected Pair<Integer, Integer> getTotalResultCount(List<R> results) {
        Integer size = results.size();
        return new Pair<Integer, Integer>(size, size);
    }

    protected boolean isApplyPostQueryPaging() {
        return true;
    }

    protected List<List<R>> applyPostQueryPaging(List<R> results, CannedQueryPageDetails pageDetails) {
        int skipResults = pageDetails.getSkipResults();
        int pageSize = pageDetails.getPageSize();
        int pageCount = pageDetails.getPageCount();
        int pageNumber = pageDetails.getPageNumber();
        int availableResults = results.size();
        int totalResults = pageSize * pageCount;
        int firstResult = skipResults + (pageNumber - 1) * pageSize;
        ArrayList<List<R>> pages = new ArrayList<List<R>>(pageCount);
        if (skipResults == 0 && pageSize > availableResults) {
            return Collections.singletonList(results);
        }
        if (firstResult > availableResults) {
            return pages;
        }
        ListIterator<R> iterator = results.listIterator(firstResult);
        ArrayList page = new ArrayList(Math.min(results.size(), pageSize));
        pages.add(page);
        for (int countTotal = 0; iterator.hasNext() && countTotal < totalResults; ++countTotal) {
            if (page.size() == pageSize) {
                page = new ArrayList(pageSize);
                pages.add(page);
            }
            Object next = iterator.next();
            page.add(next);
        }
        return pages;
    }
}

