/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.commongrams.CommonGramsFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.IndexSchema;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalDataFactory;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

@Bindable
public class SolrStopwordsCarrot2LexicalDataFactory
implements ILexicalDataFactory {
    @Init
    @Input
    @Attribute(key="solrCore")
    public SolrCore core;
    @Processing
    @Input
    @Attribute(key="solrFieldNames")
    public Set<String> fieldNames;
    private HashMap<String, List<CharArraySet>> solrStopWords = new HashMap();
    public DefaultLexicalDataFactory carrot2LexicalDataFactory = new DefaultLexicalDataFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CharArraySet> getSolrStopWordsForField(String fieldName) {
        HashMap<String, List<CharArraySet>> hashMap = this.solrStopWords;
        synchronized (hashMap) {
            if (!this.solrStopWords.containsKey(fieldName)) {
                this.solrStopWords.put(fieldName, new ArrayList());
                IndexSchema schema = this.core.getLatestSchema();
                Analyzer fieldAnalyzer = schema.getFieldType(fieldName).getIndexAnalyzer();
                if (fieldAnalyzer instanceof TokenizerChain) {
                    TokenFilterFactory[] filterFactories;
                    for (TokenFilterFactory factory : filterFactories = ((TokenizerChain)fieldAnalyzer).getTokenFilterFactories()) {
                        if (factory instanceof StopFilterFactory) {
                            CharArraySet stopWords = ((StopFilterFactory)factory).getStopWords();
                            this.solrStopWords.get(fieldName).add(stopWords);
                        }
                        if (!(factory instanceof CommonGramsFilterFactory)) continue;
                        CharArraySet commonWords = ((CommonGramsFilterFactory)factory).getCommonWords();
                        this.solrStopWords.get(fieldName).add(commonWords);
                    }
                }
            }
            return this.solrStopWords.get(fieldName);
        }
    }

    public ILexicalData getLexicalData(LanguageCode languageCode) {
        final ILexicalData carrot2LexicalData = this.carrot2LexicalDataFactory.getLexicalData(languageCode);
        return new ILexicalData(){

            public boolean isStopLabel(CharSequence word) {
                return carrot2LexicalData.isStopLabel(word);
            }

            public boolean isCommonWord(MutableCharArray word) {
                for (String fieldName : SolrStopwordsCarrot2LexicalDataFactory.this.fieldNames) {
                    for (CharArraySet stopWords : SolrStopwordsCarrot2LexicalDataFactory.this.getSolrStopWordsForField(fieldName)) {
                        if (!stopWords.contains((CharSequence)word)) continue;
                        return true;
                    }
                }
                return carrot2LexicalData.isCommonWord(word);
            }
        };
    }
}

