/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.repo.search.impl.QueryParserUtils;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoClientDataModelServicesFactory;
import org.alfresco.solr.AlfrescoSolr4FunctionEvaluationContext;
import org.alfresco.solr.ContextAwareQuery;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.query.Lucene4QueryBuilderContextSolrImpl;
import org.alfresco.solr.query.Solr4QueryParser;
import org.alfresco.solr.tracker.pool.DefaultTrackerPoolFactory;
import org.alfresco.util.NumericEncoder;
import org.alfresco.util.Pair;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Version;
import org.apache.solr.core.CoreDescriptorDecorator;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class AlfrescoSolrDataModel
implements QueryConstants {
    public static final String CONTENT_S_LOCALE_PREFIX = "content@s__locale@";
    static final String PART_FIELDNAME_PREFIX = "part@sd@";
    static final Set<String> DATE_PART_SUFFIXES = Set.of("_unit_of_time_year", "_unit_of_time_quarter", "_unit_of_time_month", "_unit_of_time_day_of_month", "_unit_of_time_day_of_week", "_unit_of_time_day_of_year", "_unit_of_time_hour", "_unit_of_time_minute", "_unit_of_time_second");
    private static final String SINGLE_VALUE_WITHOUT_DOC_VALUES_MARKER = "@s_@";
    private static final String SINGLE_VALUE_WITH_DOC_VALUES_MARKER = "@sd@";
    static final String SHARED_PROPERTIES = "shared.properties";
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoSolrDataModel.class);
    private static final String CHANGE_SET = "CHANGE_SET";
    private static final String TX = "TX";
    public static final String DEFAULT_TENANT = "_DEFAULT_";
    private static final AlfrescoSolrDataModel INSTANCE = new AlfrescoSolrDataModel();
    private final TenantService tenantService;
    private final NamespaceDAO namespaceDAO;
    private final DictionaryDAOImpl dictionaryDAO;
    private final Map<String, DictionaryComponent> dictionaryServices;
    private final Map<AlfrescoClientDataModelServicesFactory.DictionaryKey, CMISAbstractDictionaryService> cmisDictionaryServices;
    private final Map<String, Set<String>> modelErrors = new HashMap<String, Set<String>>();
    private final Set<QName> suggestableProperties = new HashSet<QName>();
    private final Set<QName> crossLocaleSearchDataTypes = new HashSet<QName>();
    private final Set<QName> crossLocaleSearchProperties = new HashSet<QName>();
    private final Set<QName> identifierProperties = new HashSet<QName>();
    private final ThreadPoolExecutor threadPool;

    public void close() {
        this.threadPool.shutdown();
    }

    public AlfrescoSolrDataModel() {
        this.tenantService = new SingleTServiceImpl();
        this.dictionaryDAO = new DictionaryDAOImpl();
        this.dictionaryDAO.setTenantService(this.tenantService);
        try {
            CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
            compiledModelsCache.setDictionaryDAO(this.dictionaryDAO);
            compiledModelsCache.setTenantService(this.tenantService);
            compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
            DefaultTrackerPoolFactory trackerPoolFactory = new DefaultTrackerPoolFactory(new Properties(), "_dictionary_", "_internal_");
            this.threadPool = trackerPoolFactory.create();
            compiledModelsCache.setThreadPoolExecutor(this.threadPool);
            this.dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
            this.dictionaryDAO.setResourceClassLoader(this.getResourceClassLoader());
            this.dictionaryDAO.init();
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to create dictionaryDAO ", (Throwable)e);
        }
        this.namespaceDAO = this.dictionaryDAO;
        QNameFilter qnameFilter = this.getQNameFilter();
        this.dictionaryServices = AlfrescoClientDataModelServicesFactory.constructDictionaryServices((QNameFilter)qnameFilter, (DictionaryDAOImpl)this.dictionaryDAO);
        DictionaryComponent dictionaryComponent = this.getDictionaryService("DEFAULT_DICTIONARY");
        dictionaryComponent.setMessageLookup((MessageLookup)new StaticMessageLookup());
        this.cmisDictionaryServices = AlfrescoClientDataModelServicesFactory.constructDictionaries((QNameFilter)qnameFilter, (NamespaceDAO)this.namespaceDAO, (DictionaryComponent)dictionaryComponent, (DictionaryDAO)this.dictionaryDAO);
        Properties props = AlfrescoSolrDataModel.getCommonConfig();
        for (Object key : props.keySet()) {
            QName qName;
            String stringKey = (String)key;
            if (stringKey.startsWith("alfresco.suggestable.property.")) {
                qName = QName.createQName((String)props.getProperty(stringKey));
                this.suggestableProperties.add(qName);
                continue;
            }
            if (stringKey.startsWith("alfresco.cross.locale.property.")) {
                qName = QName.createQName((String)props.getProperty(stringKey));
                this.crossLocaleSearchProperties.add(qName);
                continue;
            }
            if (stringKey.startsWith("alfresco.cross.locale.datatype.")) {
                qName = QName.createQName((String)props.getProperty(stringKey));
                this.crossLocaleSearchDataTypes.add(qName);
                continue;
            }
            if (!stringKey.startsWith("alfresco.identifier.property.")) continue;
            qName = QName.createQName((String)props.getProperty(stringKey));
            this.identifierProperties.add(qName);
        }
        if (props.isEmpty()) {
            this.suggestableProperties.add(ContentModel.PROP_NAME);
            this.suggestableProperties.add(ContentModel.PROP_TITLE);
            this.suggestableProperties.add(ContentModel.PROP_DESCRIPTION);
            this.suggestableProperties.add(ContentModel.PROP_CONTENT);
            this.crossLocaleSearchDataTypes.add(DataTypeDefinition.TEXT);
            this.crossLocaleSearchDataTypes.add(DataTypeDefinition.CONTENT);
            this.crossLocaleSearchDataTypes.add(DataTypeDefinition.MLTEXT);
            this.identifierProperties.add(ContentModel.PROP_CREATOR);
            this.identifierProperties.add(ContentModel.PROP_MODIFIER);
            this.identifierProperties.add(ContentModel.PROP_USERNAME);
            this.identifierProperties.add(ContentModel.PROP_AUTHORITY_NAME);
        }
    }

    public static String getTenantId(String tenant) {
        if (tenant == null || tenant.equals("")) {
            return DEFAULT_TENANT;
        }
        return tenant.replaceAll("!", "_-._");
    }

    public static String getAclDocumentId(String tenant, Long aclId) {
        return AlfrescoSolrDataModel.getTenantId(tenant) + "!" + NumericEncoder.encode((Long)aclId) + "!ACL";
    }

    public static String getAclChangeSetDocumentId(Long aclChangeSetId) {
        return "TRACKER!CHANGE_SET!" + NumericEncoder.encode((Long)aclChangeSetId);
    }

    public static Long parseTransactionId(String documentId) {
        return AlfrescoSolrDataModel.parseIdFromDocumentId(documentId);
    }

    private static Long parseIdFromDocumentId(String documentId) {
        String[] split = documentId.split("!");
        if (split.length > 0) {
            return NumericEncoder.decodeLong((String)split[split.length - 1]);
        }
        return null;
    }

    public static String getNodeDocumentId(String tenant, Long dbid) {
        return AlfrescoSolrDataModel.getTenantId(tenant) + "!" + NumericEncoder.encode((Long)dbid);
    }

    public static TenantDbId decodeNodeDocumentId(String id) {
        TenantDbId ids = new TenantDbId();
        String[] split = id.split("!");
        if (split.length > 0) {
            ids.tenant = split[0];
        }
        if (split.length > 1) {
            ids.dbId = NumericEncoder.decodeLong((String)split[1]);
        }
        return ids;
    }

    public static String getTransactionDocumentId(Long txId) {
        return "TRACKER!TX!" + NumericEncoder.encode((Long)txId);
    }

    public String getAlfrescoPropertyFromSchemaField(String schemaField) {
        int index = schemaField.lastIndexOf("@{");
        if (index == -1) {
            return schemaField;
        }
        String alfrescoQueryField = schemaField.substring(index + 1);
        QName qName = QName.createQName((String)alfrescoQueryField);
        alfrescoQueryField = qName.toPrefixString((NamespacePrefixResolver)this.namespaceDAO);
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(qName);
        if (propertyDefinition == null) {
            return alfrescoQueryField;
        }
        if (!propertyDefinition.isIndexed() && !propertyDefinition.isStoredInIndex()) {
            return alfrescoQueryField;
        }
        DataTypeDefinition dataTypeDefinition = propertyDefinition.getDataType();
        if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.CONTENT)) {
            if (schemaField.contains("__size@")) {
                return alfrescoQueryField + ".size";
            }
            if (schemaField.contains("__locale@")) {
                return alfrescoQueryField + ".locale";
            }
            if (schemaField.contains("__mimetype@")) {
                return alfrescoQueryField + ".mimetype";
            }
            if (schemaField.contains("__encoding@")) {
                return alfrescoQueryField + ".encoding";
            }
            if (schemaField.contains("__docid@")) {
                return alfrescoQueryField + ".docid";
            }
            if (schemaField.contains("__tr_ex@")) {
                return alfrescoQueryField + ".tr_ex";
            }
            if (schemaField.contains("__tr_time@")) {
                return alfrescoQueryField + ".tr_time";
            }
            if (schemaField.contains("__tr_status@")) {
                return alfrescoQueryField + ".tr_status";
            }
            return alfrescoQueryField;
        }
        return alfrescoQueryField;
    }

    public static AlfrescoSolrDataModel getInstance() {
        return INSTANCE;
    }

    public NamespaceDAO getNamespaceDAO() {
        return this.namespaceDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QNameFilter getQNameFilter() {
        QNameFilter qnameFilter = null;
        FileSystemXmlApplicationContext ctx = null;
        File resourceDirectory = AlfrescoSolrDataModel.getResourceDirectory();
        File filterContext = new File(resourceDirectory, "opencmis-qnamefilter-context.xml");
        if (!filterContext.exists()) {
            log.info("No type filter context found at " + filterContext.getAbsolutePath() + ", no type filtering");
            return qnameFilter;
        }
        try {
            ctx = new FileSystemXmlApplicationContext(new String[]{"file:" + filterContext.getAbsolutePath()}, false);
            ctx.setClassLoader(this.getClass().getClassLoader());
            ctx.refresh();
            qnameFilter = (QNameFilter)ctx.getBean("cmisTypeExclusions");
            if (qnameFilter == null) {
                log.warn("Unable to find type filter at " + filterContext.getAbsolutePath() + ", no type filtering");
            }
        }
        catch (BeansException e) {
            log.warn("Unable to parse type filter at " + filterContext.getAbsolutePath() + ", no type filtering");
        }
        finally {
            if (ctx != null && ctx.getBeanFactory() != null && ctx.isActive()) {
                ctx.close();
            }
        }
        return qnameFilter;
    }

    public static Properties getCommonConfig() {
        File resourceDirectory = AlfrescoSolrDataModel.getResourceDirectory();
        File propertiesFile = new File(resourceDirectory, SHARED_PROPERTIES);
        Properties props = new Properties();
        if (!propertiesFile.exists()) {
            log.info("No shared properties found at  " + propertiesFile.getAbsolutePath());
            return props;
        }
        try (FileInputStream is = new FileInputStream(propertiesFile);){
            props.load(is);
        }
        catch (IOException e) {
            log.info("Failed to read shared properties at  " + propertiesFile.getAbsolutePath());
        }
        return props;
    }

    public ClassLoader getResourceClassLoader() {
        File f = AlfrescoSolrDataModel.getResourceDirectory();
        if (f.canRead() && f.isDirectory()) {
            URL[] urls = new URL[1];
            try {
                URL url;
                urls[0] = url = f.toURI().normalize().toURL();
            }
            catch (MalformedURLException e) {
                throw new AlfrescoRuntimeException("Failed to add resources to classpath ", (Throwable)e);
            }
            return URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        }
        return this.getClass().getClassLoader();
    }

    public static File getResourceDirectory() {
        return new File(SolrResourceLoader.locateSolrHome().toFile(), "conf");
    }

    public DictionaryComponent getDictionaryService(String alternativeDictionary) {
        DictionaryComponent dictionaryComponent = null;
        if (alternativeDictionary != null && !alternativeDictionary.trim().isEmpty()) {
            dictionaryComponent = this.dictionaryServices.get(alternativeDictionary);
        }
        if (dictionaryComponent == null) {
            dictionaryComponent = this.dictionaryServices.get("DEFAULT_DICTIONARY");
        }
        return dictionaryComponent;
    }

    public IndexedField getIndexedFieldForSpecializedPropertyMetadata(QName propertyQName, SpecializedFieldType type) {
        String dateDerivedSuffix;
        IndexedField indexedField = new IndexedField();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        if (propertyDefinition == null) {
            return indexedField;
        }
        if (!propertyDefinition.isIndexed() && !propertyDefinition.isStoredInIndex()) {
            return indexedField;
        }
        DataTypeDefinition dataTypeDefinition = propertyDefinition.getDataType();
        if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.CONTENT)) {
            StringBuilder builder = new StringBuilder();
            builder.append(dataTypeDefinition.getName().getLocalName());
            builder.append('@');
            builder.append('s');
            builder.append("_");
            builder.append('_');
            switch (type) {
                case CONTENT_DOCID: {
                    builder.append("docid");
                    break;
                }
                case CONTENT_ENCODING: {
                    builder.append("encoding");
                    break;
                }
                case CONTENT_LOCALE: {
                    builder.append("locale");
                    break;
                }
                case CONTENT_MIMETYPE: {
                    builder.append("mimetype");
                    break;
                }
                case CONTENT_SIZE: {
                    builder.append("size");
                    break;
                }
                case TRANSFORMATION_EXCEPTION: {
                    builder.append("tr_ex");
                    break;
                }
                case TRANSFORMATION_STATUS: {
                    builder.append("tr_status");
                    break;
                }
                case TRANSFORMATION_TIME: {
                    builder.append("tr_time");
                    break;
                }
            }
            builder.append('@');
            builder.append(propertyQName);
            indexedField.addField(builder.toString(), false, false);
        } else if (this.isDateOrDatetime(dataTypeDefinition) && (dateDerivedSuffix = this.getDateDerivedSuffix(type)) != null) {
            indexedField.addField(this.getDateDerivedField(propertyQName, dateDerivedSuffix), false, true);
        }
        return indexedField;
    }

    public IndexedField getQueryableFields(QName propertyQName, SpecializedFieldType type, FieldUse fieldUse) {
        if (type != null) {
            return this.getIndexedFieldForSpecializedPropertyMetadata(propertyQName, type);
        }
        IndexedField indexedField = new IndexedField();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        if (propertyDefinition == null) {
            indexedField.addField("_dummy_", false, false);
            return indexedField;
        }
        if (!propertyDefinition.isIndexed() && !propertyDefinition.isStoredInIndex()) {
            indexedField.addField("_dummy_", false, false);
            return indexedField;
        }
        if (this.isTextField(propertyDefinition)) {
            switch (fieldUse) {
                case COMPLETION: {
                    this.addCompletionFields(propertyDefinition, indexedField);
                    break;
                }
                case FACET: {
                    this.addFacetSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case FTS: {
                    this.addFullTextSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case ID: {
                    this.addIdentifierSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case EXACT: {
                    this.addExactSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case MULTI_FACET: {
                    this.addMultiSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case SORT: {
                    this.addSortSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case STATS: {
                    this.addStatsSearchFields(propertyDefinition, indexedField);
                    break;
                }
                case SUGGESTION: {
                    if (this.isSuggestable(propertyQName)) {
                        indexedField.addField("suggest", false, false);
                    }
                    this.addCompletionFields(propertyDefinition, indexedField);
                    break;
                }
                case HIGHLIGHT: {
                    this.addHighlightSearchFields(propertyDefinition, indexedField);
                }
            }
        } else {
            indexedField.addField(this.getFieldForNonText(propertyDefinition), false, false);
        }
        return indexedField;
    }

    private void addCompletionFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
            if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            } else {
                indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
            }
        } else if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE) {
            if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            } else {
                indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
            }
        } else if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE) {
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        }
    }

    private void addFullTextSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (!(propertyDefinition.getIndexTokenisationMode() != IndexTokenisationMode.TRUE && propertyDefinition.getIndexTokenisationMode() != IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName()))) {
            indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), true, false);
            if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            }
        } else {
            indexedField.addField(this.getFieldForText(true, false, false, propertyDefinition), true, false);
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        }
    }

    private void addHighlightSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        QName propertyName = propertyDefinition.getName();
        QName propertyDataTypeQName = propertyDefinition.getDataType().getName();
        String fieldName = propertyDataTypeQName.equals((Object)DataTypeDefinition.MLTEXT) ? this.getStoredMLTextField(propertyName) : (propertyDataTypeQName.equals((Object)DataTypeDefinition.CONTENT) ? this.getStoredContentField(propertyName) : this.getStoredTextField(propertyName));
        indexedField.addField(fieldName, false, false);
    }

    private void addIdentifierSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
            indexedField.addField(this.getFieldForText(true, false, false, propertyDefinition), true, false);
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        } else {
            indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), true, false);
            if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            }
        }
    }

    private void addExactSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE) {
            indexedField.addField(this.getFieldForText(true, false, false, propertyDefinition), true, false);
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        } else if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
            indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
        } else {
            throw new UnsupportedOperationException("Exact Term search is not supported unless you configure the field <" + String.valueOf(propertyDefinition.getName()) + "> for cross locale search");
        }
    }

    private void addFacetSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT) && !this.isIdentifierTextProperty(propertyDefinition.getName()) && propertyDefinition.getFacetable() == Facetable.TRUE) {
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        }
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName())) {
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        } else if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
            indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
        } else {
            indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
        }
    }

    private void addMultiSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName())) {
            indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
        } else if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
            indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
        } else {
            indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
        }
    }

    private void addStatsSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        this.addFacetSearchFields(propertyDefinition, indexedField);
    }

    private void addSortSearchFields(PropertyDefinition propertyDefinition, IndexedField indexedField) {
        DataTypeDefinition dataTypeDefinition = propertyDefinition.getDataType();
        if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.TEXT) && !propertyDefinition.isMultiValued()) {
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                indexedField.addField(this.getFieldForText(false, false, true, propertyDefinition), false, true);
            } else if (this.isIdentifierTextProperty(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
            } else if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            } else {
                indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
            }
        }
        if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.MLTEXT) && !propertyDefinition.isMultiValued()) {
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                indexedField.addField(this.getFieldForText(false, false, true, propertyDefinition), false, true);
            } else if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
            } else {
                indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), false, false);
            }
        }
    }

    public String getStoredTextField(QName propertyQName) {
        return this.getStoredTextField(propertyQName, null);
    }

    public String getStoredTextField(QName propertyQName, String suffix) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        StringBuilder sb = new StringBuilder();
        sb.append("text@" + (propertyDefinition.isMultiValued() ? "m" : "s") + "_stored_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH ? "t" : "_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName()) ? "s" : "_");
        sb.append(this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName()) ? "c" : "_");
        sb.append((propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName())) && !propertyDefinition.isMultiValued() ? "s" : "_");
        sb.append(this.isSuggestable(propertyQName) ? "s" : "_");
        sb.append("@");
        sb.append(propertyDefinition.getName().toString());
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public String getStoredMLTextField(QName propertyQName) {
        return this.getStoredMLTextField(propertyQName, null);
    }

    public String getStoredMLTextField(QName propertyQName, String suffix) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        StringBuilder sb = new StringBuilder();
        sb.append("mltext@m_stored_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH ? "t" : "_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName()) ? "s" : "_");
        sb.append(this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName()) ? "c" : "_");
        sb.append("_");
        sb.append(this.isSuggestable(propertyQName) ? "s" : "_");
        sb.append("@");
        sb.append(propertyDefinition.getName().toString());
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public String getStoredContentField(QName propertyQName) {
        return this.getStoredContentField(propertyQName, null);
    }

    public String getStoredContentField(QName propertyQName, String suffix) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        StringBuilder sb = new StringBuilder();
        sb.append("content@s_stored_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH ? "t" : "_");
        sb.append(propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName()) ? "s" : "_");
        sb.append(this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName()) ? "c" : "_");
        sb.append("_");
        sb.append(this.isSuggestable(propertyQName) ? "s" : "_");
        sb.append("@");
        sb.append(propertyDefinition.getName().toString());
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public String getDateDerivedField(QName propertyQName, String suffix) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        return PART_FIELDNAME_PREFIX + propertyDefinition.getName().toString() + suffix;
    }

    public String getDateDerivedSuffix(SpecializedFieldType type) {
        switch (type) {
            case UNIT_OF_TIME_SECOND: {
                return "_unit_of_time_second";
            }
            case UNIT_OF_TIME_MINUTE: {
                return "_unit_of_time_minute";
            }
            case UNIT_OF_TIME_HOUR: {
                return "_unit_of_time_hour";
            }
            case UNIT_OF_TIME_DAY: {
                return "_unit_of_time_day_of_month";
            }
            case UNIT_OF_TIME_DAY_OF_WEEK: {
                return "_unit_of_time_day_of_week";
            }
            case UNIT_OF_TIME_DAY_OF_YEAR: {
                return "_unit_of_time_day_of_year";
            }
            case UNIT_OF_TIME_MONTH: {
                return "_unit_of_time_month";
            }
            case UNIT_OF_TIME_QUARTER: {
                return "_unit_of_time_quarter";
            }
            case UNIT_OF_TIME_YEAR: {
                return "_unit_of_time_year";
            }
        }
        return null;
    }

    public IndexedField getIndexedFieldNamesForProperty(QName propertyQName) {
        IndexedField indexedField = new IndexedField();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(propertyQName);
        if (propertyDefinition == null) {
            return indexedField;
        }
        if (!propertyDefinition.isIndexed() && !propertyDefinition.isStoredInIndex()) {
            return indexedField;
        }
        DataTypeDefinition dataTypeDefinition = propertyDefinition.getDataType();
        if (this.isTextField(propertyDefinition)) {
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                indexedField.addField(this.getFieldForText(true, true, false, propertyDefinition), true, false);
                if (this.crossLocaleSearchDataTypes.contains(propertyDefinition.getDataType().getName()) || this.crossLocaleSearchProperties.contains(propertyDefinition.getName())) {
                    indexedField.addField(this.getFieldForText(false, true, false, propertyDefinition), false, false);
                }
            }
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH || this.isIdentifierTextProperty(propertyDefinition.getName())) {
                indexedField.addField(this.getFieldForText(true, false, false, propertyDefinition), true, false);
                indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
            }
            if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.TEXT)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    if (!propertyDefinition.isMultiValued()) {
                        indexedField.addField(this.getFieldForText(false, false, true, propertyDefinition), false, true);
                    }
                } else if (!this.isIdentifierTextProperty(propertyDefinition.getName()) && propertyDefinition.getFacetable() == Facetable.TRUE) {
                    indexedField.addField(this.getFieldForText(false, false, false, propertyDefinition), false, false);
                }
            }
            if (dataTypeDefinition.getName().equals((Object)DataTypeDefinition.MLTEXT) && (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) && !propertyDefinition.isMultiValued()) {
                indexedField.addField(this.getFieldForText(true, false, true, propertyDefinition), true, true);
            }
            if (this.isSuggestable(propertyQName)) {
                indexedField.addField("suggest_@" + propertyDefinition.getName().toString(), false, false);
            }
        } else {
            indexedField.addField(this.getFieldForNonText(propertyDefinition), false, false);
        }
        return indexedField;
    }

    private boolean isIdentifierTextProperty(QName propertyQName) {
        return this.identifierProperties.contains(propertyQName);
    }

    public boolean isTextField(PropertyDefinition propertyDefinition) {
        return Optional.ofNullable(propertyDefinition).map(PropertyDefinition::getDataType).map(DataTypeDefinition::getName).map(name -> name.equals((Object)DataTypeDefinition.MLTEXT) || name.equals((Object)DataTypeDefinition.CONTENT) || name.equals((Object)DataTypeDefinition.TEXT)).orElse(false);
    }

    private boolean isSuggestable(QName propertyQName) {
        if (propertyQName == null) {
            return false;
        }
        return this.suggestableProperties.contains(propertyQName);
    }

    private boolean hasDocValues(PropertyDefinition propertyDefinition) {
        if (this.isTextField(propertyDefinition)) {
            return propertyDefinition.getFacetable() != Facetable.FALSE;
        }
        if (propertyDefinition.getFacetable() == Facetable.FALSE) {
            return false;
        }
        if (propertyDefinition.getFacetable() == Facetable.TRUE) {
            return true;
        }
        if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE) {
            return false;
        }
        return this.isPrimitive(propertyDefinition.getDataType());
    }

    public String getFieldForNonText(PropertyDefinition propertyDefinition) {
        StringBuilder builder = new StringBuilder();
        QName qName = propertyDefinition.getDataType().getName();
        builder.append(qName.getLocalName());
        builder.append("@");
        builder.append(propertyDefinition.isMultiValued() ? "m" : "s");
        builder.append(this.hasDocValues(propertyDefinition) ? "d" : "_");
        builder.append("@");
        builder.append(propertyDefinition.getName().toString());
        return builder.toString();
    }

    private String getFieldForText(boolean localised, boolean tokenised, boolean sort, PropertyDefinition propertyDefinition) {
        StringBuilder builder = new StringBuilder();
        QName qName = propertyDefinition.getDataType().getName();
        builder.append(qName.getLocalName());
        builder.append("@");
        QName propertyDataTypeQName = propertyDefinition.getDataType().getName();
        if (propertyDataTypeQName.equals((Object)DataTypeDefinition.MLTEXT)) {
            builder.append('m');
        } else if (propertyDataTypeQName.equals((Object)DataTypeDefinition.CONTENT)) {
            builder.append('s');
        } else {
            builder.append(propertyDefinition.isMultiValued() ? "m" : "s");
        }
        if (sort || localised || tokenised || propertyDataTypeQName.equals((Object)DataTypeDefinition.CONTENT) || propertyDataTypeQName.equals((Object)DataTypeDefinition.MLTEXT)) {
            builder.append('_');
        } else {
            builder.append(this.hasDocValues(propertyDefinition) ? "d" : "_");
        }
        builder.append('_');
        if (!sort) {
            builder.append(localised ? "l" : "_");
            builder.append(tokenised ? "t" : "_");
        } else {
            builder.append("sort");
        }
        builder.append("@");
        builder.append(propertyDefinition.getName().toString());
        return builder.toString();
    }

    public PropertyDefinition getPropertyDefinition(QName propertyQName) {
        return this.getDictionaryService("DEFAULT_DICTIONARY").getProperty(propertyQName);
    }

    public boolean putModel(M2Model model) {
        this.modelErrors.remove(model.getName());
        this.dictionaryDAO.putModelIgnoringConstraints(model);
        return true;
    }

    public void removeModel(QName modelQName) {
        this.modelErrors.remove(this.getM2Model(modelQName).getName());
        this.dictionaryDAO.removeModel(modelQName);
    }

    M2Model getM2Model(QName modelQName) {
        return this.dictionaryDAO.getCompiledModel(modelQName).getM2Model();
    }

    public void afterInitModels() {
        for (CMISAbstractDictionaryService cds : this.cmisDictionaryServices.values()) {
            cds.afterDictionaryInit();
        }
    }

    public Query parseCMISQueryToAlfrescoAbstractQuery(CMISQueryOptions.CMISQueryMode mode, SearchParameters searchParameters, SolrQueryRequest req, String alternativeDictionary, CmisVersion cmisVersion) {
        List selectorGroups;
        CMISQueryOptions options = new CMISQueryOptions(searchParameters.getQuery(), StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setLocales(searchParameters.getLocales());
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setQueryParameterDefinitions((List)searchParameters.getQueryParameterDefinitions());
        for (String name : searchParameters.getQueryTemplates().keySet()) {
            String template = (String)searchParameters.getQueryTemplates().get(name);
            options.addQueryTemplate(name, template);
        }
        CapabilityJoin joinSupport = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CapabilityJoin.NONE : CapabilityJoin.INNERANDOUTER;
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode, cmisVersion, alternativeDictionary);
        CMISDictionaryService cmisDictionary = this.getCMISDictionary(alternativeDictionary, cmisVersion);
        CMISQueryParser parser = new CMISQueryParser(options, cmisDictionary, joinSupport);
        Query queryModelQuery = parser.parse((QueryModelFactory)new LuceneQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        if (queryModelQuery.getSource() != null && (selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext)).size() == 0) {
            throw new UnsupportedOperationException("No selectors");
        }
        return queryModelQuery;
    }

    public CmisFunctionEvaluationContext getCMISFunctionEvaluationContext(CMISQueryOptions.CMISQueryMode mode, CmisVersion cmisVersion, String alternativeDictionary) {
        BaseTypeId[] validScopes = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.getCMISDictionary(alternativeDictionary, cmisVersion));
        functionContext.setValidScopes(validScopes);
        return functionContext;
    }

    public CMISDictionaryService getCMISDictionary(String alternativeDictionary, CmisVersion cmisVersion) {
        AlfrescoClientDataModelServicesFactory.DictionaryKey key;
        CMISDictionaryService cmisDictionary = null;
        if (alternativeDictionary != null && !alternativeDictionary.trim().isEmpty()) {
            key = new AlfrescoClientDataModelServicesFactory.DictionaryKey(cmisVersion, alternativeDictionary);
            cmisDictionary = (CMISDictionaryService)this.cmisDictionaryServices.get(key);
        }
        if (cmisDictionary == null) {
            key = new AlfrescoClientDataModelServicesFactory.DictionaryKey(cmisVersion, "DEFAULT_DICTIONARY");
            cmisDictionary = (CMISDictionaryService)this.cmisDictionaryServices.get(key);
        }
        return cmisDictionary;
    }

    public List<AlfrescoModel> getAlfrescoModels() {
        return this.dictionaryDAO.getModels().stream().map(qname -> {
            M2Model m2Model = this.dictionaryDAO.getCompiledModel(qname).getM2Model();
            return new AlfrescoModel(m2Model, Long.valueOf(this.getDictionaryService("DEFAULT_DICTIONARY").getModel(qname).getChecksum(ModelDefinition.XMLBindingType.DEFAULT)));
        }).collect(Collectors.toList());
    }

    Map<String, Set<String>> getModelErrors() {
        return this.modelErrors;
    }

    public org.apache.lucene.search.Query getCMISQuery(CMISQueryOptions.CMISQueryMode mode, Pair<SearchParameters, Boolean> searchParametersAndFilter, SolrQueryRequest req, Query queryModelQuery, CmisVersion cmisVersion, String alternativeDictionary) throws ParseException {
        SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
        Boolean isFilter = (Boolean)searchParametersAndFilter.getSecond();
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode, cmisVersion, alternativeDictionary);
        Set selectorGroup = (Set)queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext).get(0);
        QueryBuilderContext<org.apache.lucene.search.Query, Sort, ParseException> luceneContext = this.getLuceneQueryBuilderContext(searchParameters, req, alternativeDictionary, FTSQueryParser.RerankPhase.SINGLE_PASS);
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        org.apache.lucene.search.Query luceneQuery = (org.apache.lucene.search.Query)builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        return new ContextAwareQuery(luceneQuery, Boolean.TRUE.equals(isFilter) ? null : searchParameters);
    }

    public QueryBuilderContext<org.apache.lucene.search.Query, Sort, ParseException> getLuceneQueryBuilderContext(SearchParameters searchParameters, SolrQueryRequest req, String alternativeDictionary, FTSQueryParser.RerankPhase rerankPhase) {
        return new Lucene4QueryBuilderContextSolrImpl((DictionaryService)this.getDictionaryService(alternativeDictionary), (NamespacePrefixResolver)this.namespaceDAO, this.tenantService, searchParameters, MLAnalysisMode.EXACT_LANGUAGE, req, this, rerankPhase);
    }

    public Solr4QueryParser getLuceneQueryParser(SearchParameters searchParameters, SolrQueryRequest req, FTSQueryParser.RerankPhase rerankPhase) {
        Analyzer analyzer = req.getSchema().getQueryAnalyzer();
        Solr4QueryParser parser = new Solr4QueryParser(req, Version.LATEST, searchParameters.getDefaultFieldName(), analyzer, rerankPhase);
        parser.setNamespacePrefixResolver((NamespacePrefixResolver)this.namespaceDAO);
        parser.setDictionaryService((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"));
        parser.setTenantService(this.tenantService);
        parser.setSearchParameters(searchParameters);
        parser.setAllowLeadingWildcard(true);
        Properties props = new CoreDescriptorDecorator(req.getCore().getCoreDescriptor()).getProperties();
        int topTermSpanRewriteLimit = Integer.parseInt(props.getProperty("alfresco.topTermSpanRewriteLimit", "1000"));
        parser.setTopTermSpanRewriteLimit(topTermSpanRewriteLimit);
        return parser;
    }

    public org.apache.lucene.search.Query getFTSQuery(Pair<SearchParameters, Boolean> searchParametersAndFilter, SolrQueryRequest req, FTSQueryParser.RerankPhase rerankPhase) throws ParseException {
        SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
        Boolean isFilter = (Boolean)searchParametersAndFilter.getSecond();
        LuceneQueryModelFactory factory = new LuceneQueryModelFactory();
        AlfrescoSolr4FunctionEvaluationContext functionContext = new AlfrescoSolr4FunctionEvaluationContext((NamespacePrefixResolver)this.namespaceDAO, (DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), "http://www.alfresco.org/model/content/1.0", req.getSchema());
        FTSParser.Mode mode = searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.AND ? FTSParser.Mode.DEFAULT_CONJUNCTION : FTSParser.Mode.DEFAULT_DISJUNCTION;
        Constraint constraint = FTSQueryParser.buildFTS((String)searchParameters.getQuery(), (QueryModelFactory)factory, (FunctionEvaluationContext)functionContext, null, null, (FTSParser.Mode)mode, (QueryOptions.Connective)(searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND), (Map)searchParameters.getQueryTemplates(), (String)searchParameters.getDefaultFieldName(), (FTSQueryParser.RerankPhase)rerankPhase);
        Query queryModelQuery = factory.createQuery(null, null, constraint, new ArrayList());
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        QueryBuilderContext<org.apache.lucene.search.Query, Sort, ParseException> luceneContext = this.getLuceneQueryBuilderContext(searchParameters, req, "DEFAULT_DICTIONARY", rerankPhase);
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        org.apache.lucene.search.Query luceneQuery = (org.apache.lucene.search.Query)builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        return new ContextAwareQuery(luceneQuery, Boolean.TRUE.equals(isFilter) ? null : searchParameters);
    }

    private PropertyDefinition getPropertyDefinition(String identifier) {
        return QueryParserUtils.matchPropertyDefinition((String)"http://www.alfresco.org/model/content/1.0", (NamespacePrefixResolver)this.getNamespaceDAO(), (DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), (String)identifier);
    }

    public String mapProperty(String potentialProperty, FieldUse fieldUse, SolrQueryRequest req) {
        return this.mapProperty(potentialProperty, fieldUse, req, 0);
    }

    public String mapStoredProperty(String potentialProperty, SolrQueryRequest req) {
        if (potentialProperty.equals("asc") || potentialProperty.equals("desc") || potentialProperty.equals("_docid_")) {
            return potentialProperty;
        }
        if (potentialProperty.equalsIgnoreCase("score") || potentialProperty.equalsIgnoreCase("SEARCH_SCORE")) {
            return "score";
        }
        AlfrescoSolr4FunctionEvaluationContext functionContext = new AlfrescoSolr4FunctionEvaluationContext((NamespacePrefixResolver)this.getNamespaceDAO(), (DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), "http://www.alfresco.org/model/content/1.0", req.getSchema());
        Pair fieldNameAndEnding = QueryParserUtils.extractFieldNameAndEnding((String)potentialProperty);
        String luceneField = functionContext.getLuceneFieldName((String)fieldNameAndEnding.getFirst());
        PropertyDefinition propertyDef = this.getPropertyDefinition((String)fieldNameAndEnding.getFirst());
        if (propertyDef == null && luceneField.contains("@")) {
            int index = luceneField.lastIndexOf("@");
            propertyDef = this.getPropertyDefinition(luceneField.substring(index + 1));
        }
        if (propertyDef == null || propertyDef.getName() == null) {
            return this.mapNonPropertyFields(luceneField);
        }
        if (this.isDateOrDatetime(propertyDef.getDataType()) && this.isDerivedDateField((String)fieldNameAndEnding.getSecond())) {
            return this.getDateDerivedField(propertyDef.getName(), (String)fieldNameAndEnding.getSecond());
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
            return this.getStoredTextField(propertyDef.getName(), (String)fieldNameAndEnding.getSecond());
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            return this.getStoredMLTextField(propertyDef.getName(), (String)fieldNameAndEnding.getSecond());
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            return this.getStoredContentField(propertyDef.getName(), (String)fieldNameAndEnding.getSecond());
        }
        return this.mapAlfrescoField(FieldUse.FTS, 0, (Pair<String, String>)fieldNameAndEnding, luceneField, propertyDef) + (String)fieldNameAndEnding.getSecond();
    }

    public boolean isDerivedDateField(String suffix) {
        return DATE_PART_SUFFIXES.contains(suffix);
    }

    public String mapProperty(String potentialProperty, FieldUse fieldUse, SolrQueryRequest req, int position) {
        if (potentialProperty.equals("asc") || potentialProperty.equals("desc") || potentialProperty.equals("_docid_")) {
            return potentialProperty;
        }
        if (potentialProperty.equalsIgnoreCase("score") || potentialProperty.equalsIgnoreCase("SEARCH_SCORE")) {
            return "score";
        }
        if (req.getSchema().getFieldOrNull(potentialProperty) != null) {
            return this.mapNonPropertyFields(potentialProperty);
        }
        AlfrescoSolr4FunctionEvaluationContext functionContext = new AlfrescoSolr4FunctionEvaluationContext((NamespacePrefixResolver)this.getNamespaceDAO(), (DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), "http://www.alfresco.org/model/content/1.0", req.getSchema());
        Pair fieldNameAndEnding = QueryParserUtils.extractFieldNameAndEnding((String)potentialProperty);
        String luceneField = functionContext.getLuceneFieldName((String)fieldNameAndEnding.getFirst());
        PropertyDefinition propertyDef = this.getPropertyDefinition((String)fieldNameAndEnding.getFirst());
        if (propertyDef == null && luceneField.contains("@")) {
            int index = luceneField.lastIndexOf("@");
            propertyDef = this.getPropertyDefinition(luceneField.substring(index + 1));
        }
        String solrSortField = this.mapAlfrescoField(fieldUse, position, (Pair<String, String>)fieldNameAndEnding, luceneField, propertyDef);
        return solrSortField;
    }

    public String mapNonPropertyFields(String queryField) {
        switch (queryField) {
            case "ID": {
                return "LID";
            }
            case "EXACTTYPE": {
                return "TYPE";
            }
        }
        return queryField;
    }

    public SpecializedFieldType getTextField(String ending) {
        switch (ending) {
            case ".mimetype": {
                return SpecializedFieldType.CONTENT_MIMETYPE;
            }
            case ".size": {
                return SpecializedFieldType.CONTENT_SIZE;
            }
            case ".locale": {
                return SpecializedFieldType.CONTENT_LOCALE;
            }
            case ".encoding": {
                return SpecializedFieldType.CONTENT_ENCODING;
            }
            case "_unit_of_time_second": {
                return SpecializedFieldType.UNIT_OF_TIME_SECOND;
            }
            case "_unit_of_time_minute": {
                return SpecializedFieldType.UNIT_OF_TIME_MINUTE;
            }
            case "_unit_of_time_hour": {
                return SpecializedFieldType.UNIT_OF_TIME_HOUR;
            }
            case "_unit_of_time_day_of_month": {
                return SpecializedFieldType.UNIT_OF_TIME_DAY;
            }
            case "_unit_of_time_day_of_week": {
                return SpecializedFieldType.UNIT_OF_TIME_DAY_OF_WEEK;
            }
            case "_unit_of_time_day_of_year": {
                return SpecializedFieldType.UNIT_OF_TIME_DAY_OF_YEAR;
            }
            case "_unit_of_time_month": {
                return SpecializedFieldType.UNIT_OF_TIME_MONTH;
            }
            case "_unit_of_time_quarter": {
                return SpecializedFieldType.UNIT_OF_TIME_QUARTER;
            }
            case "_unit_of_time_year": {
                return SpecializedFieldType.UNIT_OF_TIME_YEAR;
            }
        }
        return null;
    }

    public void setCMDefaultUri() {
        if (this.getNamespaceDAO().getURIs().contains("http://www.alfresco.org/model/content/1.0")) {
            this.getNamespaceDAO().addPrefix("", "http://www.alfresco.org/model/content/1.0");
        }
    }

    public String destructuredDateTimePartFieldNamePrefix(String sourceFieldName) {
        String prefix = sourceFieldName.substring(0, sourceFieldName.indexOf("@"));
        String sourceFieldNamePrefixWithoutDocValues = prefix + SINGLE_VALUE_WITHOUT_DOC_VALUES_MARKER;
        String sourceFieldNamePrefixWithDocValues = prefix + SINGLE_VALUE_WITH_DOC_VALUES_MARKER;
        return sourceFieldName.replace(sourceFieldNamePrefixWithoutDocValues, PART_FIELDNAME_PREFIX).replace(sourceFieldNamePrefixWithDocValues, PART_FIELDNAME_PREFIX);
    }

    private boolean isDateOrDatetime(DataTypeDefinition dataType) {
        return dataType.getName().equals((Object)DataTypeDefinition.DATE) || dataType.getName().equals((Object)DataTypeDefinition.DATETIME);
    }

    private boolean isPrimitive(DataTypeDefinition dataType) {
        QName name = dataType.getName();
        return name.equals((Object)DataTypeDefinition.INT) || name.equals((Object)DataTypeDefinition.LONG) || name.equals((Object)DataTypeDefinition.FLOAT) || name.equals((Object)DataTypeDefinition.DOUBLE) || this.isDateOrDatetime(dataType) || name.equals((Object)DataTypeDefinition.BOOLEAN) || name.equals((Object)DataTypeDefinition.CATEGORY) || name.equals((Object)DataTypeDefinition.NODE_REF);
    }

    private String mapAlfrescoField(FieldUse fieldUse, int position, Pair<String, String> fieldNameAndEnding, String luceneField, PropertyDefinition propertyDef) {
        IndexedField fields;
        String solrSortField = propertyDef != null ? ((fields = AlfrescoSolrDataModel.getInstance().getQueryableFields(propertyDef.getName(), this.getTextField((String)fieldNameAndEnding.getSecond()), fieldUse)).getFields().size() > 0 ? (fields.getFields().size() > position ? fields.getFields().get(position).getField() : fields.getFields().get(0).getField()) : this.mapNonPropertyFields(luceneField)) : this.mapNonPropertyFields(luceneField);
        return solrSortField;
    }

    public static class TenantDbId {
        public String tenant;
        public Long dbId;
        private List<ContentPropertySpecs> contentPropertySpecsList;
        public Map<String, Object> optionalBag = new HashMap<String, Object>();

        public void setProperty(String name, Object value) {
            this.optionalBag.put(name, value);
        }

        public boolean hasAtLeastOneContentProperty() {
            return this.contentPropertySpecsList != null && !this.contentPropertySpecsList.isEmpty();
        }

        public void addContentPropertiesSpecs(List<ContentPropertySpecs> specsList) {
            this.contentPropertySpecsList = Collections.unmodifiableList(specsList);
        }

        public Stream<ContentPropertySpecs> contentPropertySpecsStream() {
            return this.contentPropertySpecsList.stream();
        }
    }

    public static class IndexedField {
        private final List<FieldInstance> fields = new LinkedList<FieldInstance>();

        public List<FieldInstance> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public void addField(String prefix, boolean localised, boolean sort) {
            this.fields.add(new FieldInstance(prefix, localised, sort));
        }
    }

    public static enum SpecializedFieldType {
        CONTENT_DOCID,
        CONTENT_SIZE,
        CONTENT_LOCALE,
        CONTENT_MIMETYPE,
        CONTENT_ENCODING,
        TRANSFORMATION_STATUS,
        TRANSFORMATION_TIME,
        TRANSFORMATION_EXCEPTION,
        UNIT_OF_TIME_SECOND,
        UNIT_OF_TIME_MINUTE,
        UNIT_OF_TIME_HOUR,
        UNIT_OF_TIME_DAY,
        UNIT_OF_TIME_DAY_OF_WEEK,
        UNIT_OF_TIME_DAY_OF_YEAR,
        UNIT_OF_TIME_MONTH,
        UNIT_OF_TIME_QUARTER,
        UNIT_OF_TIME_YEAR;

    }

    public static enum FieldUse {
        FTS,
        ID,
        EXACT,
        FACET,
        MULTI_FACET,
        STATS,
        SORT,
        SUGGESTION,
        COMPLETION,
        HIGHLIGHT;

    }

    public static class FieldInstance {
        final String field;
        final boolean localised;
        final boolean sort;

        public FieldInstance(String field, boolean localised, boolean sort) {
            this.field = field;
            this.localised = localised;
            this.sort = sort;
        }

        public String getField() {
            return this.field;
        }

        public boolean isLocalised() {
            return this.localised;
        }

        public boolean isSort() {
            return this.sort;
        }
    }

    public static class ContentPropertySpecs {
        public final String fieldName;
        public final String locale;

        public ContentPropertySpecs(String fieldName, String locale) {
            this.fieldName = fieldName;
            this.locale = locale;
        }
    }
}

