/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.query.CachingTermPositions;
import org.alfresco.solr.query.StructuredFieldPosition;

public abstract class AbstractStructuredFieldPosition
implements StructuredFieldPosition {
    private String termText;
    private boolean isTerminal;
    private boolean isAbsolute;
    private CachingTermPositions tps;

    public AbstractStructuredFieldPosition(String termText, boolean isTerminal, boolean isAbsolute) {
        this.termText = termText;
        this.isTerminal = isTerminal;
        this.isAbsolute = isAbsolute;
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    protected void setTerminal(boolean isTerminal) {
        this.isTerminal = isTerminal;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public boolean isRelative() {
        return !this.isAbsolute;
    }

    @Override
    public String getTermText() {
        return this.termText;
    }

    @Override
    public int getPosition() {
        return -1;
    }

    @Override
    public void setCachingTermPositions(CachingTermPositions tps) {
        this.tps = tps;
    }

    @Override
    public CachingTermPositions getCachingTermPositions() {
        return this.tps;
    }

    @Override
    public boolean allowsLinkingBySelf() {
        return false;
    }

    @Override
    public boolean allowslinkingByParent() {
        return true;
    }

    @Override
    public boolean linkParent() {
        return true;
    }

    @Override
    public boolean linkSelf() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getDescription());
        buffer.append("<" + this.getTermText() + "> at " + this.getPosition());
        buffer.append(" Terminal = " + this.isTerminal());
        buffer.append(" Absolute = " + this.isAbsolute());
        return buffer.toString();
    }

    public abstract String getDescription();

    @Override
    public boolean isDescendant() {
        return false;
    }

    @Override
    public boolean matchesAll() {
        return this.getCachingTermPositions() == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isAbsolute ? 1231 : 1237);
        result = 31 * result + (this.isTerminal ? 1231 : 1237);
        result = 31 * result + (this.termText == null ? 0 : this.termText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStructuredFieldPosition other = (AbstractStructuredFieldPosition)obj;
        if (this.isAbsolute != other.isAbsolute) {
            return false;
        }
        if (this.isTerminal != other.isTerminal) {
            return false;
        }
        return !(this.termText == null ? other.termText != null : !this.termText.equals(other.termText));
    }
}

