/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.ContextAwareQuery;
import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.solr.query.Solr4QueryParser;
import org.alfresco.util.Pair;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoLuceneQParserPlugin
extends QParserPlugin {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoLuceneQParserPlugin.class);
    private NamedList<Object> args;

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new AlfrescoLuceneQParser(qstr, localParams, params, req, this.args);
    }

    public void init(NamedList args) {
        this.args = args;
    }

    public static class AlfrescoLuceneQParser
    extends AbstractQParser {
        public AlfrescoLuceneQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args) {
            super(qstr, localParams, params, req, args);
        }

        public Query parse() throws SyntaxError {
            Query query;
            Pair<SearchParameters, Boolean> searchParametersAndFilter = this.getSearchParameters();
            SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
            Boolean isFilter = (Boolean)searchParametersAndFilter.getSecond();
            Solr4QueryParser qp = AlfrescoSolrDataModel.getInstance().getLuceneQueryParser(searchParameters, this.req, FTSQueryParser.RerankPhase.SINGLE_PASS_WITH_AUTO_PHRASE);
            try {
                String escapedQ = this.escape(searchParameters.getQuery());
                query = qp.parse(escapedQ);
            }
            catch (ParseException pe) {
                throw new SyntaxError((Throwable)pe);
            }
            ContextAwareQuery contextAwareQuery = new ContextAwareQuery(query, Boolean.TRUE.equals(isFilter) ? null : searchParameters);
            if (log.isDebugEnabled()) {
                log.debug("Lucene QP query as lucene:\t    " + String.valueOf((Object)contextAwareQuery));
            }
            return contextAwareQuery;
        }

        protected String escape(String in) {
            if (in.indexOf(47) == -1) {
                return in;
            }
            StringBuilder sb = new StringBuilder(in);
            boolean quoted = false;
            boolean escaped = false;
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == '\"') {
                    quoted = !quoted;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '/' && !quoted && !escaped) {
                    sb.insert(i, "\\");
                    ++i;
                }
                escaped = false;
            }
            String out = sb.toString();
            return out;
        }
    }
}

