/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.solr.query.ContentSizeGroupingAnalyticsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class ContentSizeGroupingQParserPlugin
extends QParserPlugin {
    private int scale = 1;
    private int buckets = 10;
    private NamedList<Object> args;

    public void init(NamedList args) {
        this.args = args;
        if (args != null) {
            Object val = args.get("buckets");
            if (val != null) {
                this.buckets = Integer.parseInt(val.toString());
            }
            if ((val = args.get("scale")) != null) {
                this.scale = Integer.parseInt(val.toString());
            }
        }
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ContentSizeGroupingQParser(qstr, localParams, params, req, this.args, this.scale, this.buckets);
    }

    public static class ContentSizeGroupingQParser
    extends AbstractQParser {
        private int buckets;
        private int scale;

        public ContentSizeGroupingQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args, int scale, int buckets) {
            super(qstr, localParams, params, req, args);
            this.scale = scale;
            this.buckets = buckets;
        }

        public Query parse() throws SyntaxError {
            return new ContentSizeGroupingAnalyticsQuery(this.scale, this.buckets);
        }
    }
}

