/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.ArrayList;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.query.AbsoluteStructuredFieldPosition;
import org.alfresco.solr.query.DescendantAndSelfStructuredFieldPosition;
import org.alfresco.solr.query.RelativeStructuredFieldPosition;
import org.alfresco.solr.query.SelfAxisStructuredFieldPosition;
import org.alfresco.solr.query.SolrPathQuery;
import org.alfresco.solr.query.StructuredFieldPosition;
import org.alfresco.util.ISO9075;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;

public class SolrXPathHandler
implements XPathHandler {
    private SolrPathQuery query;
    private boolean isAbsolutePath = true;
    int absolutePosition = 0;
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;

    public SolrPathQuery getQuery() {
        return this.query;
    }

    public void endAbsoluteLocationPath() throws SAXPathException {
    }

    public void endAdditiveExpr(int op) throws SAXPathException {
        switch (op) {
            case 0: {
                break;
            }
            case 7: 
            case 8: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + op);
            }
        }
    }

    public void endAllNodeStep() throws SAXPathException {
    }

    public void endAndExpr(boolean create) throws SAXPathException {
        if (create) {
            throw new UnsupportedOperationException();
        }
    }

    public void endCommentNodeStep() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endEqualityExpr(int op) throws SAXPathException {
        switch (op) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + op);
            }
        }
    }

    public void endFilterExpr() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endFunction() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endMultiplicativeExpr(int op) throws SAXPathException {
        switch (op) {
            case 0: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + op);
            }
        }
    }

    public void endNameStep() throws SAXPathException {
    }

    public void endOrExpr(boolean create) throws SAXPathException {
        if (create) {
            throw new UnsupportedOperationException();
        }
    }

    public void endPathExpr() throws SAXPathException {
    }

    public void endPredicate() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endProcessingInstructionNodeStep() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endRelationalExpr(int op) throws SAXPathException {
        switch (op) {
            case 0: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + op);
            }
        }
    }

    public void endRelativeLocationPath() throws SAXPathException {
    }

    public void endTextNodeStep() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void endUnaryExpr(int op) throws SAXPathException {
        switch (op) {
            case 0: {
                break;
            }
            case 12: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + op);
            }
        }
    }

    public void endUnionExpr(boolean create) throws SAXPathException {
        if (create) {
            throw new UnsupportedOperationException();
        }
    }

    public void endXPath() throws SAXPathException {
    }

    public void literal(String arg0) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void number(double arg0) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void number(int arg0) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startAbsoluteLocationPath() throws SAXPathException {
        if (!this.isAbsolutePath) {
            throw new IllegalStateException();
        }
    }

    public void startAdditiveExpr() throws SAXPathException {
    }

    public void startAllNodeStep(int axis) throws SAXPathException {
        switch (axis) {
            case 1: {
                if (this.isAbsolutePath) {
                    this.addRelative(null, null);
                    break;
                }
                this.addRelative(null, null);
                break;
            }
            case 12: {
                this.query.appendQuery(this.getArrayList(new DescendantAndSelfStructuredFieldPosition(), new DescendantAndSelfStructuredFieldPosition()));
                break;
            }
            case 11: {
                this.query.appendQuery(this.getArrayList(new SelfAxisStructuredFieldPosition(), new SelfAxisStructuredFieldPosition()));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private ArrayList<StructuredFieldPosition> getArrayList(StructuredFieldPosition one, StructuredFieldPosition two) {
        ArrayList<StructuredFieldPosition> answer = new ArrayList<StructuredFieldPosition>(2);
        answer.add(one);
        answer.add(two);
        return answer;
    }

    public void startAndExpr() throws SAXPathException {
    }

    public void startCommentNodeStep(int arg0) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startEqualityExpr() throws SAXPathException {
    }

    public void startFilterExpr() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startFunction(String arg0, String arg1) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startMultiplicativeExpr() throws SAXPathException {
    }

    public void startNameStep(int axis, String nameSpace, String localName) throws SAXPathException {
        switch (axis) {
            case 1: {
                if (this.isAbsolutePath) {
                    this.addRelative(nameSpace, localName);
                    break;
                }
                this.addRelative(nameSpace, localName);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void addAbsolute(String nameSpace, String localName) {
        ArrayList<StructuredFieldPosition> answer = new ArrayList<StructuredFieldPosition>(2);
        ++this.absolutePosition;
        if (nameSpace == null || nameSpace.length() == 0) {
            if (localName.equals("*")) {
                answer.add(new AbsoluteStructuredFieldPosition("*", this.absolutePosition));
            } else if (this.namespacePrefixResolver.getNamespaceURI("") == null) {
                answer.add(new AbsoluteStructuredFieldPosition("<No Namespace>", this.absolutePosition));
            } else {
                answer.add(new AbsoluteStructuredFieldPosition(this.namespacePrefixResolver.getNamespaceURI(""), this.absolutePosition));
            }
        } else {
            answer.add(new AbsoluteStructuredFieldPosition(this.namespacePrefixResolver.getNamespaceURI(nameSpace), this.absolutePosition));
        }
        ++this.absolutePosition;
        if (localName == null || localName.length() == 0) {
            answer.add(new AbsoluteStructuredFieldPosition("*", this.absolutePosition));
        } else if (localName.equals("*")) {
            answer.add(new AbsoluteStructuredFieldPosition(localName, this.absolutePosition));
        } else {
            answer.add(new AbsoluteStructuredFieldPosition(ISO9075.encode((String)QName.createValidLocalName((String)ISO9075.decode((String)localName))), this.absolutePosition));
        }
        this.query.appendQuery(answer);
    }

    private void addRelative(String nameSpace, String localName) {
        ArrayList<StructuredFieldPosition> answer = new ArrayList<StructuredFieldPosition>(2);
        if (nameSpace == null || nameSpace.length() == 0) {
            if (localName.equals("*")) {
                answer.add(new RelativeStructuredFieldPosition("*"));
            } else if (this.namespacePrefixResolver.getNamespaceURI("") == null) {
                answer.add(new RelativeStructuredFieldPosition("<No Namespace>"));
            } else if (this.namespacePrefixResolver.getNamespaceURI("").equals("")) {
                answer.add(new RelativeStructuredFieldPosition("<No Namespace>"));
            } else {
                answer.add(new RelativeStructuredFieldPosition(this.namespacePrefixResolver.getNamespaceURI("")));
            }
        } else {
            answer.add(new RelativeStructuredFieldPosition(this.namespacePrefixResolver.getNamespaceURI(nameSpace)));
        }
        if (localName == null || localName.length() == 0) {
            answer.add(new RelativeStructuredFieldPosition("*"));
        } else if (localName.equals("*")) {
            answer.add(new RelativeStructuredFieldPosition(localName));
        } else {
            answer.add(new RelativeStructuredFieldPosition(ISO9075.encode((String)QName.createValidLocalName((String)ISO9075.decode((String)localName)))));
        }
        this.query.appendQuery(answer);
    }

    public void startOrExpr() throws SAXPathException {
    }

    public void startPathExpr() throws SAXPathException {
    }

    public void startPredicate() throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startProcessingInstructionNodeStep(int arg0, String arg1) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startRelationalExpr() throws SAXPathException {
    }

    public void startRelativeLocationPath() throws SAXPathException {
        this.isAbsolutePath = false;
    }

    public void startTextNodeStep(int arg0) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public void startUnaryExpr() throws SAXPathException {
    }

    public void startUnionExpr() throws SAXPathException {
    }

    public void startXPath() throws SAXPathException {
        this.query = new SolrPathQuery(this.dictionaryService);
    }

    public void variableReference(String uri, String localName) throws SAXPathException {
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

