/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.security;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.core.SolrResourceLoader;

class SecretSharedPropertyHelper {
    private static final Function<String, Properties> toProperties = file -> {
        Properties props = new Properties();
        try {
            props.load(new FileReader((String)file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return props;
    };

    SecretSharedPropertyHelper() {
    }

    static Set<String> getPropertyFromCores(String name, String defaultValue) {
        Set<String> set;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get(SolrResourceLoader.locateSolrHome().toString(), new String[0]), new FileVisitOption[0]);
            try {
                List solrCorePropertiesFiles = walk.map(Path::toString).filter(path -> path.contains("solrcore.properties") && !path.contains("templates")).collect(Collectors.toList());
                set = solrCorePropertiesFiles.stream().map(toProperties).map(properties -> properties.getProperty(name, defaultValue)).collect(Collectors.toSet());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return set;
    }
}

