/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractWorker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean failed = true;
        Exception failCausedBy = null;
        try {
            this.doWork();
            failed = false;
            if (failed) {
                this.onFail(failCausedBy);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Index tracking batch hit an unrecoverable error ", (Throwable)e);
                failCausedBy = e;
                if (failed) {
                    this.onFail(failCausedBy);
                }
            }
            catch (Throwable throwable) {
                if (failed) {
                    this.onFail(failCausedBy);
                }
                throw throwable;
            }
        }
    }

    protected abstract void doWork() throws Exception;

    protected abstract void onFail(Throwable var1);
}

