/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker.pool;

import java.util.AbstractQueue;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.solr.tracker.pool.TrackerPoolFactory;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;

public class DefaultTrackerPoolFactory
implements TrackerPoolFactory {
    private static final int DEFAULT_CORE_POOL_SIZE = 4;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = -1;
    private static final int DEFAULT_KEEP_ALIVE_TIME = 120;
    private static final int DEFAULT_THREAD_PRIORITY = 5;
    private static final boolean DEFAULT_THREAD_DAEMON = Boolean.TRUE;
    private static final int DEFAULT_WORK_QUEUE_SIZE = -1;
    private static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();
    private String poolName = "";
    private int corePoolSize = 4;
    private int maximumPoolSize = -1;
    private int keepAliveTime = 120;
    private int threadPriority = 5;
    private boolean threadDaemon = DEFAULT_THREAD_DAEMON;
    private int workQueueSize = -1;
    private RejectedExecutionHandler rejectedExecutionHandler = DEFAULT_REJECTED_EXECUTION_HANDLER;

    private Integer parseConfig(String trackerConfig, Properties p, Integer ori) {
        if (p.getProperty(trackerConfig) != null && !p.getProperty(trackerConfig).isEmpty()) {
            return Integer.parseInt(p.getProperty(trackerConfig));
        }
        return ori;
    }

    private Boolean parseConfigBoolean(String trackerConfig, Properties p) {
        if (p.getProperty(trackerConfig) != null && !p.getProperty(trackerConfig).isEmpty()) {
            return Boolean.parseBoolean(p.getProperty(trackerConfig));
        }
        String param = "alfresco" + trackerConfig.substring(trackerConfig.lastIndexOf("."));
        return Boolean.parseBoolean(p.getProperty(param, "true"));
    }

    public DefaultTrackerPoolFactory(Properties p, String coreName, String trackerName) {
        this.corePoolSize = Integer.parseInt(p.getProperty("alfresco.corePoolSize", "4"));
        this.maximumPoolSize = Integer.parseInt(p.getProperty("alfresco.maximumPoolSize", "-1"));
        this.keepAliveTime = Integer.parseInt(p.getProperty("alfresco.keepAliveTime", "120"));
        this.threadPriority = Integer.parseInt(p.getProperty("alfresco.threadPriority", "5"));
        this.threadDaemon = Boolean.parseBoolean(p.getProperty("alfresco.threadDaemon", "true"));
        this.workQueueSize = Integer.parseInt(p.getProperty("alfresco.workQueueSize", "-1"));
        if (trackerName != null && !trackerName.isEmpty()) {
            switch (trackerName) {
                case "AclTracker": {
                    this.corePoolSize = this.parseConfig("alfresco.acl.tracker.corePoolSize", p, this.corePoolSize);
                    this.maximumPoolSize = this.parseConfig("alfresco.acl.tracker.maximumPoolSize", p, this.maximumPoolSize);
                    this.keepAliveTime = this.parseConfig("alfresco.acl.tracker.keepAliveTime", p, this.keepAliveTime);
                    this.threadPriority = this.parseConfig("alfresco.acl.tracker.threadPriority", p, this.threadPriority);
                    this.threadDaemon = this.parseConfigBoolean("alfresco.acl.tracker.threadDaemon", p);
                    this.workQueueSize = this.parseConfig("alfresco.acl.tracker.workQueueSize", p, this.workQueueSize);
                    break;
                }
                case "ContentTracker": {
                    this.corePoolSize = this.parseConfig("alfresco.content.tracker.corePoolSize", p, this.corePoolSize);
                    this.maximumPoolSize = this.parseConfig("alfresco.content.tracker.maximumPoolSize", p, this.maximumPoolSize);
                    this.keepAliveTime = this.parseConfig("alfresco.content.tracker.keepAliveTime", p, this.keepAliveTime);
                    this.threadPriority = this.parseConfig("alfresco.content.tracker.threadPriority", p, this.threadPriority);
                    this.threadDaemon = this.parseConfigBoolean("alfresco.content.tracker.threadDaemon", p);
                    this.workQueueSize = this.parseConfig("alfresco.content.tracker.workQueueSize", p, this.workQueueSize);
                    break;
                }
                case "MetadataTracker": {
                    this.corePoolSize = this.parseConfig("alfresco.metadata.tracker.corePoolSize", p, this.corePoolSize);
                    this.maximumPoolSize = this.parseConfig("alfresco.metadata.tracker.maximumPoolSize", p, this.maximumPoolSize);
                    this.keepAliveTime = this.parseConfig("alfresco.metadata.tracker.keepAliveTime", p, this.keepAliveTime);
                    this.threadPriority = this.parseConfig("alfresco.metadata.tracker.threadPriority", p, this.threadPriority);
                    this.threadDaemon = this.parseConfigBoolean("alfresco.metadata.tracker.threadDaemon", p);
                    this.workQueueSize = this.parseConfig("alfresco.metadata.tracker.workQueueSize", p, this.workQueueSize);
                    break;
                }
            }
        }
        this.poolName = "SolrTrackingPool-" + coreName + "-" + trackerName + "-";
        if (this.maximumPoolSize == -1) {
            this.maximumPoolSize = this.corePoolSize;
        }
    }

    @Override
    public ThreadPoolExecutor create() {
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setThreadDaemon(this.threadDaemon);
        threadFactory.setThreadPriority(this.threadPriority);
        if (this.poolName.length() > 0) {
            threadFactory.setNamePrefix(this.poolName);
        }
        AbstractQueue workQueue = this.workQueueSize < 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.workQueueSize);
        DynamicallySizedThreadPoolExecutor threadPoolExecutor = new DynamicallySizedThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory, this.rejectedExecutionHandler);
        return threadPoolExecutor;
    }
}

