/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoFieldMapperTransformer
extends DocTransformer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AlfrescoFieldMapperTransformer.class);
    private ResultContext context;
    private SolrReturnFields solrReturnFields;

    public void transform(SolrDocument doc, int docid, float score) {
        ArrayList fieldNames = new ArrayList(doc.getFieldNames());
        this.solrReturnFields = new SolrReturnFields(this.context.getRequest().getParams().get("originalFl"), this.context.getRequest());
        for (String fieldName : fieldNames) {
            SchemaField schemaField = this.context.getSearcher().getSchema().getFieldOrNull(fieldName);
            if (schemaField == null) continue;
            String alfrescoFieldName = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
            if (this.isRequestedField(alfrescoFieldName) || alfrescoFieldName.equals("id")) {
                Object value = doc.getFieldValue(fieldName);
                doc.removeFields(fieldName);
                if (schemaField.multiValued()) {
                    Set collectionValue = ((Collection)value).stream().map(elem -> this.getFieldValue(schemaField, elem)).collect(Collectors.toSet());
                    doc.setField(alfrescoFieldName, collectionValue);
                    continue;
                }
                doc.setField(this.transformToUnderscoreNotation(alfrescoFieldName), this.getFieldValue(schemaField, value));
                continue;
            }
            doc.removeFields(alfrescoFieldName);
            doc.removeFields(fieldName);
        }
    }

    public String getName() {
        return "fmap";
    }

    public void setContext(ResultContext context) {
        this.context = context;
    }

    private boolean isRequestedField(String fieldName) {
        return this.solrReturnFields.wantsField(this.transformToUnderscoreNotation(fieldName));
    }

    private String transformToUnderscoreNotation(String value) {
        return value.replace(":", "_");
    }

    private String removeLocale(String value) {
        int start = value.lastIndexOf(0);
        if (start == -1) {
            return value;
        }
        return value.substring(start + 1);
    }

    private Object getFieldValue(SchemaField schemaField, Object value) {
        if (value instanceof IndexableField) {
            Object indexedValue = DocsStreamer.getValue((SchemaField)schemaField, (IndexableField)((IndexableField)value));
            return indexedValue instanceof String ? this.removeLocale((String)indexedValue) : indexedValue;
        }
        return value;
    }
}

