/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.update.processor;

import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.AtomicUpdateDocumentMerger;

public class AlfrescoExplicitDocumentMerger
extends AtomicUpdateDocumentMerger {
    public AlfrescoExplicitDocumentMerger(SolrQueryRequest queryReq) {
        super(queryReq);
    }

    public SolrInputDocument merge(SolrInputDocument fromDoc, SolrInputDocument toDoc) {
        if (this.isExplicitAtomicUpdate(fromDoc)) {
            this.processInputDocuments(fromDoc, toDoc);
        }
        return super.merge(fromDoc, toDoc);
    }

    private void processInputDocuments(SolrInputDocument fromDoc, SolrInputDocument toDoc) {
        toDoc.entrySet().removeIf(entry -> fromDoc.getField((String)entry.getKey()) == null);
        fromDoc.values().removeIf(sif -> sif.getValue() instanceof Map && ((Map)sif.getValue()).get("keep") != null);
    }

    private boolean isExplicitAtomicUpdate(SolrInputDocument fromDoc) {
        return fromDoc.values().stream().map(SolrInputField::getValue).filter(value -> value instanceof Map).anyMatch(value -> ((Map)value).get("keep") != null);
    }
}

