/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Properties;
import org.alfresco.solr.config.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.core.CoreDescriptor;

public class CoreDescriptorDecorator {
    private static Log log = LogFactory.getLog(CoreDescriptorDecorator.class);
    private final Properties properties = new Properties();
    private static String SECURE_COMMS_PROPERTY = "alfresco.secureComms";
    public static final ImmutableList<String> SUBSTITUTABLE_PROPERTIES_SECURE = ImmutableList.of((Object)"alfresco.host", (Object)"alfresco.port", (Object)"alfresco.baseUrl", (Object)"alfresco.port.ssl", (Object)"alfresco.secureComms", (Object)"alfresco.encryption.ssl.keystore.passwordFileLocation", (Object)"alfresco.encryption.ssl.truststore.passwordFileLocation", (Object)"alfresco.encryption.ssl.keystore.location", (Object)"alfresco.encryption.ssl.truststore.location", (Object)"alfresco.encryption.ssl.truststore.provider", (Object)"alfresco.encryption.ssl.keystore.type", (Object)"alfresco.encryption.ssl.keystore.provider", (Object[])new String[]{"alfresco.encryption.ssl.truststore.type"});
    public static final ImmutableList<String> SUBSTITUTABLE_PROPERTIES_NONE = ImmutableList.of((Object)"alfresco.host", (Object)"alfresco.port", (Object)"alfresco.baseUrl", (Object)"alfresco.secureComms");

    public CoreDescriptorDecorator(CoreDescriptor descriptor) {
        this.properties.putAll((Map<?, ?>)descriptor.coreProperties);
        String comms = ConfigUtil.locateProperty(SECURE_COMMS_PROPERTY, "none");
        ImmutableList<String> coreProperties = comms.equals("https") ? SUBSTITUTABLE_PROPERTIES_SECURE : SUBSTITUTABLE_PROPERTIES_NONE;
        try {
            coreProperties.forEach(prop -> this.properties.put(prop, ConfigUtil.locateProperty(prop, this.properties.getProperty((String)prop))));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to locate alfresco host|port|baseUrl|ssl properties", (Throwable)e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

