/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public DeleteAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        HashMap newAliasesMap = new HashMap();
        HashMap newCollectionAliasesMap = new HashMap();
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        newCollectionAliasesMap.putAll(zkStateReader.getAliases().getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = Utils.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAliasAbsence(String name) {
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean success = false;
        Aliases aliases = null;
        while (!timeout.hasTimedOut()) {
            aliases = this.ocmh.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }
}

