/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.ExclusiveSliceProperty;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.OverseerAutoReplicaFailoverThread;
import org.apache.solr.cloud.OverseerCollectionConfigSetProcessor;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.SizeLimitedDistributedMap;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.NodeMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer
implements Closeable {
    public static final String QUEUE_OPERATION = "operation";
    public static final int STATE_UPDATE_DELAY = 2000;
    public static final int STATE_UPDATE_BATCH_SIZE = 10000;
    public static final int NUM_RESPONSES_TO_STORE = 10000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private OverseerThread arfoThread;
    private final ZkStateReader reader;
    private final ShardHandler shardHandler;
    private final UpdateShardHandler updateShardHandler;
    private final String adminPath;
    private OverseerCollectionConfigSetProcessor overseerCollectionConfigSetProcessor;
    private ZkController zkController;
    private Stats stats;
    private String id;
    private boolean closed;
    private CloudConfig config;

    public Overseer(ShardHandler shardHandler, UpdateShardHandler updateShardHandler, String adminPath, ZkStateReader reader, ZkController zkController, CloudConfig config) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.updateShardHandler = updateShardHandler;
        this.adminPath = adminPath;
        this.zkController = zkController;
        this.stats = new Stats();
        this.config = config;
    }

    public synchronized void start(String id) {
        this.id = id;
        this.closed = false;
        this.doClose();
        this.stats = new Stats();
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id, this.stats), "OverseerStateUpdate-" + id);
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        OverseerNodePrioritizer overseerPrioritizer = new OverseerNodePrioritizer(this.reader, this.adminPath, this.shardHandler.getShardHandlerFactory());
        this.overseerCollectionConfigSetProcessor = new OverseerCollectionConfigSetProcessor(this.reader, id, this.shardHandler, this.adminPath, this.stats, this, overseerPrioritizer);
        this.ccThread = new OverseerThread(ccTg, this.overseerCollectionConfigSetProcessor, "OverseerCollectionConfigSetProcessor-" + id);
        this.ccThread.setDaemon(true);
        ThreadGroup ohcfTg = new ThreadGroup("Overseer Hdfs SolrCore Failover Thread.");
        OverseerAutoReplicaFailoverThread autoReplicaFailoverThread = new OverseerAutoReplicaFailoverThread(this.config, this.reader, this.updateShardHandler);
        this.arfoThread = new OverseerThread(ohcfTg, autoReplicaFailoverThread, "OverseerHdfsCoreFailoverThread-" + id);
        this.arfoThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
        this.arfoThread.start();
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public Stats getStats() {
        return this.stats;
    }

    ZkController getZkController() {
        return this.zkController;
    }

    public synchronized OverseerThread getUpdaterThread() {
        return this.updaterThread;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        log.info("Overseer (id=" + this.id + ") closing");
        this.doClose();
        this.closed = true;
        assert (ObjectReleaseTracker.release((Object)this));
    }

    private void doClose() {
        if (this.updaterThread != null) {
            IOUtils.closeQuietly((Closeable)this.updaterThread);
            this.updaterThread.interrupt();
        }
        if (this.ccThread != null) {
            IOUtils.closeQuietly((Closeable)this.ccThread);
            this.ccThread.interrupt();
        }
        if (this.arfoThread != null) {
            IOUtils.closeQuietly((Closeable)this.arfoThread);
            this.arfoThread.interrupt();
        }
        if (this.updaterThread != null) {
            try {
                this.updaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.ccThread != null) {
            try {
                this.ccThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.arfoThread != null) {
            try {
                this.arfoThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updaterThread = null;
        this.ccThread = null;
        this.arfoThread = null;
    }

    public static DistributedQueue getStateUpdateQueue(SolrZkClient zkClient) {
        return Overseer.getStateUpdateQueue(zkClient, new Stats());
    }

    static DistributedQueue getStateUpdateQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", zkStats);
    }

    static DistributedQueue getInternalWorkQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", zkStats);
    }

    static DistributedMap getRunningMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedMap(zkClient, "/overseer/collection-map-running");
    }

    static DistributedMap getCompletedMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-completed", 10000);
    }

    static DistributedMap getFailureMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-failure", 10000);
    }

    static OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient) {
        return Overseer.getCollectionQueue(zkClient, new Stats());
    }

    static OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new OverseerTaskQueue(zkClient, "/overseer/collection-queue-work", zkStats);
    }

    static OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient) {
        return Overseer.getConfigSetQueue(zkClient, new Stats());
    }

    static OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return Overseer.getCollectionQueue(zkClient, zkStats);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isLegacy(ZkStateReader stateReader) {
        String legacyProperty = (String)stateReader.getClusterProperty("legacyCloud", (Object)"true");
        return !"false".equals(legacyProperty);
    }

    public ZkStateReader getZkStateReader() {
        return this.reader;
    }

    public static class FailedOp {
        public final ZkNodeProps req;
        public final SolrResponse resp;

        public FailedOp(ZkNodeProps req, SolrResponse resp) {
            this.req = req;
            this.resp = resp;
        }
    }

    public static class Stat {
        public final AtomicInteger success = new AtomicInteger();
        public final AtomicInteger errors = new AtomicInteger();
        public final Timer requestTime = new Timer();
        public final LinkedList<FailedOp> failureDetails = new LinkedList();
    }

    public static class Stats {
        static final int MAX_STORED_FAILURES = 10;
        final Map<String, Stat> stats = new ConcurrentHashMap<String, Stat>();
        private volatile int queueLength;

        public Map<String, Stat> getStats() {
            return this.stats;
        }

        public int getSuccessCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.success.get();
        }

        public int getErrorCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.errors.get();
        }

        public void success(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.success.incrementAndGet();
        }

        public void error(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.errors.incrementAndGet();
        }

        public Timer.Context time(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            return stat.requestTime.time();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeFailureDetails(String operation, ZkNodeProps request, SolrResponse resp) {
            LinkedList<FailedOp> failedOps;
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                if (failedOps.size() >= 10) {
                    failedOps.removeFirst();
                }
                failedOps.addLast(new FailedOp(request, resp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FailedOp> getFailureDetails(String operation) {
            LinkedList<FailedOp> failedOps;
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            if (stat == null || stat.failureDetails.isEmpty()) {
                return null;
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                ArrayList<FailedOp> ret = new ArrayList<FailedOp>(failedOps);
                return ret;
            }
        }

        public int getQueueLength() {
            return this.queueLength;
        }

        public void setQueueLength(int queueLength) {
            this.queueLength = queueLength;
        }

        public void clear() {
            this.stats.clear();
        }
    }

    static class OverseerThread
    extends Thread
    implements Closeable {
        protected volatile boolean isClosed;
        private Closeable thread;

        public OverseerThread(ThreadGroup tg, Closeable thread) {
            super(tg, (Runnable)((Object)thread));
            this.thread = thread;
        }

        public OverseerThread(ThreadGroup ccTg, Closeable thread, String name) {
            super(ccTg, (Runnable)((Object)thread), name);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            this.thread.close();
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    Closeable {
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private final DistributedMap runningMap;
        private final DistributedMap completedMap;
        private final DistributedMap failureMap;
        private final Stats zkStats;
        private boolean isClosed = false;

        public ClusterStateUpdater(ZkStateReader reader, String myId, Stats zkStats) {
            this.zkClient = reader.getZkClient();
            this.zkStats = zkStats;
            this.stateUpdateQueue = Overseer.getStateUpdateQueue(this.zkClient, zkStats);
            this.workQueue = Overseer.getInternalWorkQueue(this.zkClient, zkStats);
            this.failureMap = Overseer.getFailureMap(this.zkClient);
            this.runningMap = Overseer.getRunningMap(this.zkClient);
            this.completedMap = Overseer.getCompletedMap(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        public Stats getStateUpdateQueueStats() {
            return this.stateUpdateQueue.getStats();
        }

        public Stats getWorkQueueStats() {
            return this.workQueue.getStats();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClusterState processQueueItem(ZkNodeProps message, ClusterState clusterState, ZkStateWriter zkStateWriter, boolean enableBatching, ZkStateWriter.ZkWriteCallback callback) throws Exception {
            String operation = message.getStr(Overseer.QUEUE_OPERATION);
            List<ZkWriteCommand> zkWriteCommands = null;
            Timer.Context timerContext = Overseer.this.stats.time(operation);
            try {
                zkWriteCommands = this.processMessage(clusterState, message, operation);
                Overseer.this.stats.success(operation);
            }
            catch (Exception e) {
                log.error("Overseer could not process the current clusterstate state update message, skipping the message.", (Throwable)e);
                Overseer.this.stats.error(operation);
            }
            finally {
                timerContext.stop();
            }
            if (zkWriteCommands != null) {
                for (ZkWriteCommand zkWriteCommand : zkWriteCommands) {
                    clusterState = zkStateWriter.enqueueUpdate(clusterState, zkWriteCommand, callback);
                }
                if (!enableBatching) {
                    clusterState = zkStateWriter.writePendingUpdates();
                }
            }
            return clusterState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIfIamStillLeader() {
            byte[] data;
            if (Overseer.this.zkController != null && Overseer.this.zkController.getCoreContainer().isShutDown()) {
                return;
            }
            org.apache.zookeeper.data.Stat stat = new org.apache.zookeeper.data.Stat();
            String path = "/overseer_elect/leader";
            try {
                data = this.zkClient.getData(path, null, stat, true);
            }
            catch (Exception e) {
                log.error("could not read the data", (Throwable)e);
                return;
            }
            try {
                Map m = (Map)Utils.fromJSON((byte[])data);
                String id = (String)m.get("id");
                if (Overseer.this.overseerCollectionConfigSetProcessor.getId().equals(id)) {
                    try {
                        log.warn("I'm exiting, but I'm still the leader");
                        this.zkClient.delete(path, stat.getVersion(), true);
                    }
                    catch (KeeperException.BadVersionException badVersionException) {
                    }
                    catch (Exception e) {
                        log.error("Could not delete my leader node ", (Throwable)e);
                    }
                } else {
                    log.debug("somebody else has already taken up the overseer position");
                }
            }
            finally {
                try {
                    if (Overseer.this.zkController != null && !Overseer.this.zkController.getCoreContainer().isShutDown()) {
                        Overseer.this.zkController.rejoinOverseerElection(null, false);
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to rejoinElection ", (Throwable)e);
                }
            }
        }

        private List<ZkWriteCommand> processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            block26: {
                block25: {
                    CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)operation);
                    if (collectionAction == null) break block25;
                    switch (collectionAction) {
                        case CREATE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getZkStateReader()).createCollection(clusterState, message));
                        }
                        case DELETE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getZkStateReader()).deleteCollection(clusterState, message));
                        }
                        case CREATESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getZkStateReader()).createShard(clusterState, message));
                        }
                        case DELETESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getZkStateReader()).deleteShard(clusterState, message));
                        }
                        case ADDREPLICA: {
                            return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).addReplica(clusterState, message));
                        }
                        case ADDREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).addReplicaProperty(clusterState, message));
                        }
                        case DELETEREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).deleteReplicaProperty(clusterState, message));
                        }
                        case BALANCESHARDUNIQUE: {
                            ExclusiveSliceProperty dProp = new ExclusiveSliceProperty(clusterState, message);
                            if (dProp.balanceProperty()) {
                                String collName = message.getStr("collection");
                                return Collections.singletonList(new ZkWriteCommand(collName, dProp.getDocCollection()));
                            }
                            break block26;
                        }
                        case MODIFYCOLLECTION: {
                            CollectionsHandler.verifyRuleParams(Overseer.this.zkController.getCoreContainer(), message.getProperties());
                            return Collections.singletonList(new CollectionMutator(this.reader).modifyCollection(clusterState, message));
                        }
                        case MIGRATESTATEFORMAT: {
                            return Collections.singletonList(new ClusterStateMutator(this.reader).migrateStateFormat(clusterState, message));
                        }
                        default: {
                            throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                        }
                    }
                }
                OverseerAction overseerAction = OverseerAction.get(operation);
                if (overseerAction == null) {
                    throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                }
                switch (overseerAction) {
                    case STATE: {
                        return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).setState(clusterState, message));
                    }
                    case LEADER: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).setShardLeader(clusterState, message));
                    }
                    case DELETECORE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).removeReplica(clusterState, message));
                    }
                    case ADDROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).addRoutingRule(clusterState, message));
                    }
                    case REMOVEROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).removeRoutingRule(clusterState, message));
                    }
                    case UPDATESHARDSTATE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).updateShardState(clusterState, message));
                    }
                    case QUIT: {
                        if (this.myId.equals(message.get("id"))) {
                            log.info("Quit command received {} {}", (Object)message, (Object)LeaderElector.getNodeName(this.myId));
                            Overseer.this.overseerCollectionConfigSetProcessor.close();
                            this.close();
                            break;
                        }
                        log.warn("Overseer received wrong QUIT message {}", (Object)message);
                        break;
                    }
                    case DOWNNODE: {
                        return new NodeMutator().downNode(clusterState, message);
                    }
                    default: {
                        throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                    }
                }
            }
            return Collections.singletonList(ZkStateWriter.NO_OP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeaderStatus amILeader() {
            Timer.Context timerContext = Overseer.this.stats.time("am_i_leader");
            boolean success = true;
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    LeaderStatus leaderStatus = LeaderStatus.YES;
                    return leaderStatus;
                }
            }
            catch (KeeperException e) {
                success = false;
                if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.error("", (Throwable)e);
                    LeaderStatus leaderStatus = LeaderStatus.DONT_KNOW;
                    return leaderStatus;
                }
                if (e.code() != KeeperException.Code.SESSIONEXPIRED) {
                    log.warn("", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                success = false;
                Thread.currentThread().interrupt();
            }
            finally {
                timerContext.stop();
                if (success) {
                    Overseer.this.stats.success("am_i_leader");
                } else {
                    Overseer.this.stats.error("am_i_leader");
                }
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return LeaderStatus.NO;
        }

        @Override
        public void close() {
            this.isClosed = true;
        }
    }

    static enum LeaderStatus {
        DONT_KNOW,
        NO,
        YES;

    }
}

