/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.apache.solr.cloud.CloudConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigSetService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrResourceLoader parentLoader;

    public static ConfigSetService createConfigSetService(NodeConfig nodeConfig, SolrResourceLoader loader, ZkController zkController) {
        if (zkController != null) {
            return new CloudConfigSetService(loader, zkController);
        }
        if (nodeConfig.hasSchemaCache()) {
            return new SchemaCaching(loader, nodeConfig.getConfigSetBaseDirectory());
        }
        return new Default(loader, nodeConfig.getConfigSetBaseDirectory());
    }

    public ConfigSetService(SolrResourceLoader loader) {
        this.parentLoader = loader;
    }

    public final ConfigSet getConfig(CoreDescriptor dcore) {
        SolrResourceLoader coreLoader = this.createCoreResourceLoader(dcore);
        try {
            NamedList properties = this.createConfigSetProperties(dcore, coreLoader);
            NamedList flags = this.getConfigSetFlags(dcore, coreLoader);
            boolean trusted = !(coreLoader instanceof ZkSolrResourceLoader) || flags == null || flags.get("trusted") == null || flags.getBooleanArg("trusted") != false;
            SolrConfig solrConfig = this.createSolrConfig(dcore, coreLoader);
            IndexSchema schema = this.createIndexSchema(dcore, solrConfig);
            return new ConfigSet(this.configName(dcore), solrConfig, schema, properties, trusted);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load conf for core " + dcore.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected SolrConfig createSolrConfig(CoreDescriptor cd, SolrResourceLoader loader) {
        return SolrConfig.readFromResourceLoader(loader, cd.getConfigName());
    }

    protected IndexSchema createIndexSchema(CoreDescriptor cd, SolrConfig solrConfig) {
        return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
    }

    protected NamedList createConfigSetProperties(CoreDescriptor cd, SolrResourceLoader loader) {
        return ConfigSetProperties.readFromResourceLoader(loader, cd.getConfigSetPropertiesName());
    }

    protected NamedList getConfigSetFlags(CoreDescriptor cd, SolrResourceLoader loader) {
        if (loader instanceof ZkSolrResourceLoader) {
            try {
                return ConfigSetProperties.readFromResourceLoader(loader, ".");
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    protected abstract SolrResourceLoader createCoreResourceLoader(CoreDescriptor var1);

    public abstract String configName(CoreDescriptor var1);

    public static class SchemaCaching
    extends Default {
        private final Cache<String, IndexSchema> schemaCache = CacheBuilder.newBuilder().build();
        public static final DateTimeFormatter cacheKeyFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");

        public SchemaCaching(SolrResourceLoader loader, Path configSetBase) {
            super(loader, configSetBase);
        }

        public static String cacheName(Path schemaFile) throws IOException {
            long lastModified = Files.getLastModifiedTime(schemaFile, new LinkOption[0]).toMillis();
            return String.format(Locale.ROOT, "%s:%s", schemaFile.toString(), cacheKeyFormatter.print(lastModified));
        }

        @Override
        public IndexSchema createIndexSchema(CoreDescriptor cd, SolrConfig solrConfig) {
            String resourceNameToBeUsed = IndexSchemaFactory.getResourceNameToBeUsed(cd.getSchemaName(), solrConfig);
            Path schemaFile = Paths.get(solrConfig.getResourceLoader().getConfigDir(), new String[0]).resolve(resourceNameToBeUsed);
            if (Files.exists(schemaFile, new LinkOption[0])) {
                try {
                    String cachedName = SchemaCaching.cacheName(schemaFile);
                    return (IndexSchema)this.schemaCache.get((Object)cachedName, () -> {
                        logger.info("Creating new index schema for core {}", (Object)cd.getName());
                        return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
                    });
                }
                catch (ExecutionException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating index schema for core " + cd.getName(), (Throwable)e);
                }
                catch (IOException e) {
                    logger.warn("Couldn't get last modified time for schema file {}: {}", (Object)schemaFile, (Object)e.getMessage());
                    logger.warn("Will not use schema cache");
                }
            }
            return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
        }
    }

    public static class Default
    extends ConfigSetService {
        private final Path configSetBase;

        public Default(SolrResourceLoader loader, Path configSetBase) {
            super(loader);
            this.configSetBase = configSetBase;
        }

        @Override
        public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
            Path instanceDir = this.locateInstanceDir(cd);
            return new SolrResourceLoader(instanceDir, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties());
        }

        @Override
        public String configName(CoreDescriptor cd) {
            return (cd.getConfigSet() == null ? "instancedir " : "configset ") + this.locateInstanceDir(cd);
        }

        protected Path locateInstanceDir(CoreDescriptor cd) {
            String configSet = cd.getConfigSet();
            if (configSet == null) {
                return cd.getInstanceDir();
            }
            Path configSetDirectory = this.configSetBase.resolve(configSet);
            if (!Files.isDirectory(configSetDirectory, new LinkOption[0])) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load configuration from directory " + configSetDirectory);
            }
            return configSetDirectory;
        }
    }
}

