/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.WriteableValue;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.RenameFieldTransformer;
import org.apache.solr.response.transform.TransformerFactory;

public class RawValueTransformerFactory
extends TransformerFactory {
    String applyToWT = null;

    public RawValueTransformerFactory() {
    }

    public RawValueTransformerFactory(String wt) {
        this.applyToWT = wt;
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        if (this.defaultUserArgs != null && this.defaultUserArgs.startsWith("wt=")) {
            this.applyToWT = this.defaultUserArgs.substring(3);
        }
    }

    @Override
    public DocTransformer create(String display, SolrParams params, SolrQueryRequest req) {
        String field = params.get("f");
        if (Strings.isNullOrEmpty((String)field)) {
            field = display;
        }
        boolean apply = true;
        if (this.applyToWT != null) {
            String qwt = req.getParams().get("wt");
            if (qwt == null) {
                QueryResponseWriter dw;
                QueryResponseWriter qw = req.getCore().getQueryResponseWriter(req);
                if (qw != (dw = req.getCore().getQueryResponseWriter(this.applyToWT))) {
                    apply = false;
                }
            } else {
                apply = this.applyToWT.equals(qwt);
            }
        }
        if (apply) {
            return new RawTransformer(field, display);
        }
        if (field.equals(display)) {
            return null;
        }
        return new RenameFieldTransformer(field, display, false);
    }

    public static class WriteableStringValue
    extends WriteableValue {
        public final Object val;

        public WriteableStringValue(Object val) {
            this.val = val;
        }

        @Override
        public void write(String name, TextResponseWriter writer) throws IOException {
            String str = null;
            str = this.val instanceof IndexableField ? ((IndexableField)this.val).stringValue() : this.val.toString();
            writer.getWriter().write(str);
        }

        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            JavaBinCodec.ObjectResolver orig = codec.getResolver();
            if (orig != null) {
                codec.writeVal(orig.resolve(this.val, codec));
                return null;
            }
            return this.val.toString();
        }
    }

    static class RawTransformer
    extends DocTransformer {
        final String field;
        final String display;

        public RawTransformer(String field, String display) {
            this.field = field;
            this.display = display;
        }

        @Override
        public String getName() {
            return this.display;
        }

        @Override
        public void transform(SolrDocument doc, int docid, float score) {
            Object val = doc.remove((Object)this.field);
            if (val == null) {
                return;
            }
            if (val instanceof Collection) {
                Collection current = (Collection)val;
                ArrayList<WriteableStringValue> vals = new ArrayList<WriteableStringValue>();
                for (Object v : current) {
                    vals.add(new WriteableStringValue(v));
                }
                doc.setField(this.display, vals);
            } else {
                doc.setField(this.display, (Object)new WriteableStringValue(val));
            }
        }

        @Override
        public String[] getExtraRequestFields() {
            return new String[]{this.field};
        }
    }
}

