/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ConstValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.queries.function.valuesource.LiteralValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BoolConstValueSource;
import org.apache.solr.search.LongConstValueSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.facet.AggValueSource;

public class FunctionQParser
extends QParser {
    public static final int FLAG_CONSUME_DELIMITER = 1;
    public static final int FLAG_IS_AGG = 2;
    public static final int FLAG_DEFAULT = 1;
    public StrParser sp;
    boolean parseMultipleSources = true;
    boolean parseToEnd = true;
    private boolean argWasQuoted;

    public FunctionQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
        this.setString(qstr);
    }

    @Override
    public void setString(String s) {
        super.setString(s);
        if (s != null) {
            this.sp = new StrParser(s);
        }
    }

    public void setParseMultipleSources(boolean parseMultipleSources) {
        this.parseMultipleSources = parseMultipleSources;
    }

    public boolean getParseMultipleSources() {
        return this.parseMultipleSources;
    }

    public void setParseToEnd(boolean parseToEnd) {
        this.parseToEnd = parseToEnd;
    }

    public boolean getParseToEnd() {
        return this.parseMultipleSources;
    }

    @Override
    public Query parse() throws SyntaxError {
        ValueSource vs = null;
        ArrayList<ValueSource> lst = null;
        while (true) {
            ValueSource valsource = this.parseValueSource(0);
            this.sp.eatws();
            if (!this.parseMultipleSources) {
                vs = valsource;
                break;
            }
            if (lst != null) {
                lst.add(valsource);
            } else {
                vs = valsource;
            }
            if (this.sp.peek() != ',') break;
            this.consumeArgumentDelimiter();
            if (lst != null) continue;
            lst = new ArrayList<ValueSource>(2);
            lst.add(valsource);
        }
        if (this.parseToEnd && this.sp.pos < this.sp.end) {
            throw new SyntaxError("Unexpected text after function: " + this.sp.val.substring(this.sp.pos, this.sp.end));
        }
        if (lst != null) {
            vs = new VectorValueSource((List)lst);
        }
        return new FunctionQuery(vs);
    }

    public boolean hasMoreArguments() throws SyntaxError {
        char ch = this.sp.peek();
        return ch != '\u0000' && ch != ')';
    }

    public String parseId() throws SyntaxError {
        String value = this.parseArg();
        if (this.argWasQuoted) {
            throw new SyntaxError("Expected identifier instead of quoted string:" + value);
        }
        return value;
    }

    public Float parseFloat() throws SyntaxError {
        String str = this.parseArg();
        if (this.argWasQuoted()) {
            throw new SyntaxError("Expected float instead of quoted string:" + str);
        }
        float value = Float.parseFloat(str);
        return Float.valueOf(value);
    }

    public double parseDouble() throws SyntaxError {
        String str = this.parseArg();
        if (this.argWasQuoted()) {
            throw new SyntaxError("Expected double instead of quoted string:" + str);
        }
        double value = Double.parseDouble(str);
        return value;
    }

    public int parseInt() throws SyntaxError {
        String str = this.parseArg();
        if (this.argWasQuoted()) {
            throw new SyntaxError("Expected double instead of quoted string:" + str);
        }
        int value = Integer.parseInt(str);
        return value;
    }

    public boolean argWasQuoted() {
        return this.argWasQuoted;
    }

    public String parseArg() throws SyntaxError {
        this.argWasQuoted = false;
        this.sp.eatws();
        char ch = this.sp.peek();
        String val = null;
        block0 : switch (ch) {
            case ')': {
                return null;
            }
            case '$': {
                ++this.sp.pos;
                String param = this.sp.getId();
                val = this.getParam(param);
                break;
            }
            case '\"': 
            case '\'': {
                val = this.sp.getQuotedString();
                this.argWasQuoted = true;
                break;
            }
            default: {
                int valStart = this.sp.pos;
                while (true) {
                    if (this.sp.pos >= this.sp.end) {
                        throw new SyntaxError("Missing end to unquoted value starting at " + valStart + " str='" + this.sp.val + "'");
                    }
                    char c = this.sp.val.charAt(this.sp.pos);
                    if (c == ')' || c == ',' || Character.isWhitespace(c)) {
                        val = this.sp.val.substring(valStart, this.sp.pos);
                        break block0;
                    }
                    ++this.sp.pos;
                }
            }
        }
        this.sp.eatws();
        this.consumeArgumentDelimiter();
        return val;
    }

    public List<ValueSource> parseValueSourceList() throws SyntaxError {
        ArrayList<ValueSource> sources = new ArrayList<ValueSource>(3);
        while (this.hasMoreArguments()) {
            sources.add(this.parseValueSource(1));
        }
        return sources;
    }

    public ValueSource parseValueSource() throws SyntaxError {
        return this.parseValueSource(1);
    }

    public Query parseNestedQuery() throws SyntaxError {
        Query nestedQuery;
        if (this.sp.opt("$")) {
            String param = this.sp.getId();
            String qstr = this.getParam(param);
            qstr = qstr == null ? "" : qstr;
            nestedQuery = this.subQuery(qstr, null).getQuery();
        } else {
            String v = this.sp.val;
            String qs = v;
            int start = this.sp.pos;
            ModifiableSolrParams nestedLocalParams = new ModifiableSolrParams();
            int end = QueryParsing.parseLocalParams(qs, start, nestedLocalParams, this.getParams());
            if (end > start) {
                if (nestedLocalParams.get("v") == null) {
                    QParser sub = this.subQuery(qs, null);
                    throw new SyntaxError("Nested local params must have value in v parameter.  got '" + qs + "'");
                }
            } else {
                throw new SyntaxError("Nested function query must use $param or {!v=value} forms. got '" + qs + "'");
            }
            QParser sub = this.subQuery(qs.substring(start, end), null);
            this.sp.pos += end - start;
            nestedQuery = sub.getQuery();
        }
        this.consumeArgumentDelimiter();
        return nestedQuery;
    }

    protected ValueSource parseValueSource(boolean doConsumeDelimiter) throws SyntaxError {
        return this.parseValueSource(doConsumeDelimiter ? 1 : 0);
    }

    protected ValueSource parseValueSource(int flags) throws SyntaxError {
        Object valueSource;
        char ch = this.sp.peek();
        if (ch >= '0' && ch <= '9' || ch == '.' || ch == '+' || ch == '-') {
            Number num = this.sp.getNumber();
            valueSource = num instanceof Long ? new LongConstValueSource(num.longValue()) : (num instanceof Double ? new DoubleConstValueSource(num.doubleValue()) : new ConstValueSource(num.floatValue()));
        } else if (ch == '\"' || ch == '\'') {
            valueSource = new LiteralValueSource(this.sp.getQuotedString());
        } else if (ch == '$') {
            Query subQuery;
            ++this.sp.pos;
            String param = this.sp.getId();
            String val = this.getParam(param);
            if (val == null) {
                throw new SyntaxError("Missing param " + param + " while parsing function '" + this.sp.val + "'");
            }
            QParser subParser = this.subQuery(val, "func");
            if (subParser instanceof FunctionQParser) {
                ((FunctionQParser)subParser).setParseMultipleSources(true);
            }
            valueSource = (subQuery = subParser.getQuery()) instanceof FunctionQuery ? ((FunctionQuery)subQuery).getValueSource() : new QueryValueSource(subQuery, 0.0f);
        } else {
            String id = this.sp.getId();
            if (this.sp.opt("(")) {
                ValueSourceParser argParser = this.req.getCore().getValueSourceParser(id);
                if (argParser == null) {
                    throw new SyntaxError("Unknown function " + id + " in FunctionQuery(" + this.sp + ")");
                }
                valueSource = argParser.parse(this);
                this.sp.expect(")");
            } else if ("true".equals(id)) {
                valueSource = new BoolConstValueSource(true);
            } else if ("false".equals(id)) {
                valueSource = new BoolConstValueSource(false);
            } else {
                SchemaField f = this.req.getSchema().getField(id);
                valueSource = f.getType().getValueSource(f, this);
            }
        }
        if ((flags & 1) != 0) {
            this.consumeArgumentDelimiter();
        }
        return valueSource;
    }

    public AggValueSource parseAgg(int flags) throws SyntaxError {
        String id = this.sp.getId();
        AggValueSource vs = null;
        boolean hasParen = false;
        if ("agg".equals(id)) {
            hasParen = this.sp.opt("(");
            vs = this.parseAgg(flags | 2);
        } else {
            if (!id.startsWith("agg_")) {
                id = "agg_" + id;
            }
            hasParen = this.sp.opt("(");
            ValueSourceParser argParser = this.req.getCore().getValueSourceParser(id);
            argParser = this.req.getCore().getValueSourceParser(id);
            if (argParser == null) {
                throw new SyntaxError("Unknown aggregation " + id + " in (" + this.sp + ")");
            }
            ValueSource vv = argParser.parse(this);
            if (!(vv instanceof AggValueSource) && argParser == null) {
                throw new SyntaxError("Expected aggregation from " + id + " but got (" + vv + ") in (" + this.sp + ")");
            }
            vs = (AggValueSource)vv;
        }
        if (hasParen) {
            this.sp.expect(")");
        }
        if ((flags & 1) != 0) {
            this.consumeArgumentDelimiter();
        }
        return vs;
    }

    protected boolean consumeArgumentDelimiter() throws SyntaxError {
        if (this.hasMoreArguments()) {
            this.sp.expect(",");
            return true;
        }
        return false;
    }
}

