/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;

class GraphTermsCollector
extends SimpleCollector
implements Collector {
    private String field;
    private BytesRefHash collectorTerms;
    private SortedSetDocValues docTermOrds;
    private Bits currentResult;
    private DocSet leafNodes;
    int numHits = 0;
    BitSet bits;
    final int maxDoc;
    int base;
    int baseInParent;
    boolean hasCycles = false;

    GraphTermsCollector(String field, int maxDoc, Bits currentResult, DocSet leafNodes) {
        this.field = field;
        this.maxDoc = maxDoc;
        this.collectorTerms = new BytesRefHash();
        this.currentResult = currentResult;
        this.leafNodes = leafNodes;
        if (this.bits == null) {
            this.bits = new FixedBitSet(maxDoc);
        }
    }

    public void collect(int doc) throws IOException {
        if (this.currentResult.get(doc += this.base)) {
            this.hasCycles = true;
            return;
        }
        this.addDocToResult(doc);
        if (!this.leafNodes.exists(doc)) {
            this.addEdgeIdsToResult(doc - this.base);
        }
    }

    private void addEdgeIdsToResult(int doc) throws IOException {
        long ord;
        this.docTermOrds.setDocument(doc);
        BytesRef edgeValue = new BytesRef();
        while ((ord = this.docTermOrds.nextOrd()) != -1L) {
            edgeValue = this.docTermOrds.lookupOrd(ord);
            this.collectorTerms.add(edgeValue);
        }
    }

    private void addDocToResult(int docWithBase) {
        this.bits.set(docWithBase);
        ++this.numHits;
    }

    public BitDocSet getDocSet() {
        if (this.bits == null) {
            this.bits = new FixedBitSet(this.maxDoc);
        }
        return new BitDocSet((FixedBitSet)this.bits, this.numHits);
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docTermOrds = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.field);
        this.base = context.docBase;
        this.baseInParent = context.docBaseInParent;
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    public boolean needsScores() {
        return false;
    }
}

