/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.HttpClientInterceptorPlugin;
import org.apache.solr.util.CryptoKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIAuthenticationPlugin
extends AuthenticationPlugin
implements HttpClientInterceptorPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PublicKey> keyCache = new ConcurrentHashMap<String, PublicKey>();
    private final CryptoKeys.RSAKeyPair keyPair = new CryptoKeys.RSAKeyPair();
    private final CoreContainer cores;
    private final int MAX_VALIDITY = Integer.parseInt(System.getProperty("pkiauth.ttl", "10000"));
    private final String myNodeName;
    private boolean interceptorRegistered = false;
    private HttpHeaderClientConfigurer clientConfigurer = new HttpHeaderClientConfigurer();
    public static final String HEADER = "SolrAuth";
    public static final String PATH = "/admin/info/key";
    public static final String NODE_IS_USER = "$";
    private static final Principal SU = new BasicUserPrincipal("$");

    public void setInterceptorRegistered() {
        this.interceptorRegistered = true;
    }

    public boolean isInterceptorRegistered() {
        return this.interceptorRegistered;
    }

    public PKIAuthenticationPlugin(CoreContainer cores, String nodeName) {
        this.cores = cores;
        this.myNodeName = nodeName;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
    }

    @Override
    @SuppressForbidden(reason="Needs currentTimeMillis to compare against time in header")
    public boolean doAuthenticate(ServletRequest request, ServletResponse response, FilterChain filterChain) throws Exception {
        String cipher;
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI.endsWith(PATH)) {
            filterChain.doFilter(request, response);
            return true;
        }
        long receivedTime = System.currentTimeMillis();
        String header = ((HttpServletRequest)request).getHeader(HEADER);
        if (header == null) {
            log.error("No SolrAuth header present");
            filterChain.doFilter(request, response);
            return true;
        }
        List authInfo = StrUtils.splitWS((String)header, (boolean)false);
        if (authInfo.size() < 2) {
            log.error("Invalid SolrAuth Header {}", (Object)header);
            filterChain.doFilter(request, response);
            return true;
        }
        String nodeName = (String)authInfo.get(0);
        PKIHeaderData decipher = this.decipherHeader(nodeName, cipher = (String)authInfo.get(1));
        if (decipher == null) {
            log.error("Could not decipher a header {} . No principal set", (Object)header);
            filterChain.doFilter(request, response);
            return true;
        }
        if (receivedTime - decipher.timestamp > (long)this.MAX_VALIDITY) {
            log.error("Invalid key request timestamp: {} , received timestamp: {} , TTL: {}", new Object[]{decipher.timestamp, receivedTime, this.MAX_VALIDITY});
            filterChain.doFilter(request, response);
            return true;
        }
        Principal principal = NODE_IS_USER.equals(decipher.userName) ? SU : new BasicUserPrincipal(decipher.userName);
        filterChain.doFilter((ServletRequest)PKIAuthenticationPlugin.getWrapper((HttpServletRequest)request, principal), response);
        return true;
    }

    private static HttpServletRequestWrapper getWrapper(HttpServletRequest request, final Principal principal) {
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private PKIHeaderData decipherHeader(String nodeName, String cipherBase64) {
        PKIHeaderData header;
        PublicKey key = this.keyCache.get(nodeName);
        if (key == null) {
            log.debug("No key available for node : {} fetching now ", (Object)nodeName);
            key = this.getRemotePublicKey(nodeName);
            log.debug("public key obtained {} ", (Object)key);
        }
        if ((header = PKIAuthenticationPlugin.parseCipher(cipherBase64, key)) == null) {
            log.warn("Failed to decrypt header, trying after refreshing the key ");
            key = this.getRemotePublicKey(nodeName);
            return PKIAuthenticationPlugin.parseCipher(cipherBase64, key);
        }
        return header;
    }

    private static PKIHeaderData parseCipher(String cipher, PublicKey key) {
        byte[] bytes;
        try {
            bytes = CryptoKeys.decryptRSA(Base64.base64ToByteArray((String)cipher), key);
        }
        catch (Exception e) {
            log.error("Decryption failed , key must be wrong", (Throwable)e);
            return null;
        }
        String s = new String(bytes, StandardCharsets.UTF_8).trim();
        String[] ss = s.split(" ");
        if (ss.length < 2) {
            log.warn("Invalid cipher {} deciphered data {}", (Object)cipher, (Object)s);
            return null;
        }
        PKIHeaderData headerData = new PKIHeaderData();
        try {
            headerData.timestamp = Long.parseLong(ss[1]);
            headerData.userName = ss[0];
            log.debug("Successfully decrypted header {} {}", (Object)headerData.userName, (Object)headerData.timestamp);
            return headerData;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid cipher {}", (Object)cipher);
            return null;
        }
    }

    PublicKey getRemotePublicKey(String nodename) {
        if (!this.cores.getZkController().getZkStateReader().getClusterState().getLiveNodes().contains(nodename)) {
            return null;
        }
        String url = this.cores.getZkController().getZkStateReader().getBaseUrlForNodeName(nodename);
        try {
            String uri = url + PATH + "?wt=json&omitHeader=true";
            log.debug("Fetching fresh public key from : {}", (Object)uri);
            HttpResponse rsp = this.cores.getUpdateShardHandler().getHttpClient().execute((HttpUriRequest)new HttpGet(uri), (HttpContext)HttpClientUtil.createNewHttpClientRequestContext());
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)rsp.getEntity());
            Map m = (Map)Utils.fromJSON((byte[])bytes);
            String key = (String)m.get("key");
            if (key == null) {
                log.error("No key available from " + url + PATH);
                return null;
            }
            log.info("New Key obtained from  node: {} / {}", (Object)nodename, (Object)key);
            PublicKey pubKey = CryptoKeys.deserializeX509PublicKey(key);
            this.keyCache.put(nodename, pubKey);
            return pubKey;
        }
        catch (Exception e) {
            log.error("Exception trying to get public key from : " + url, (Throwable)e);
            return null;
        }
    }

    @Override
    public HttpClientConfigurer getClientConfigurer() {
        return this.clientConfigurer;
    }

    public SolrRequestHandler getRequestHandler() {
        return new RequestHandlerBase(){

            @Override
            public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
                rsp.add("key", PKIAuthenticationPlugin.this.keyPair.getPublicKeyStr());
            }

            @Override
            public String getDescription() {
                return "Return the public key of this server";
            }

            @Override
            public SolrInfoMBean.Category getCategory() {
                return SolrInfoMBean.Category.ADMIN;
            }
        };
    }

    public boolean needsAuthorization(HttpServletRequest req) {
        return req.getUserPrincipal() != SU;
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set current time in header")
    void setHeader(HttpRequest httpRequest) {
        String usr;
        SolrRequestInfo reqInfo = this.getRequestInfo();
        if (reqInfo != null) {
            Principal principal = reqInfo.getUserPrincipal();
            if (principal == null) {
                return;
            }
            usr = principal.getName();
        } else {
            if (!this.isSolrThread()) {
                return;
            }
            usr = NODE_IS_USER;
        }
        String s = usr + " " + System.currentTimeMillis();
        byte[] payload = s.getBytes(StandardCharsets.UTF_8);
        byte[] payloadCipher = this.keyPair.encrypt(ByteBuffer.wrap(payload));
        String base64Cipher = Base64.byteArrayToBase64((byte[])payloadCipher);
        httpRequest.setHeader(HEADER, this.myNodeName + " " + base64Cipher);
    }

    boolean isSolrThread() {
        return ExecutorUtil.isSolrServerThread();
    }

    SolrRequestInfo getRequestInfo() {
        return SolrRequestInfo.getRequestInfo();
    }

    boolean disabled() {
        return this.cores.getAuthenticationPlugin() == null || this.cores.getAuthenticationPlugin() instanceof HttpClientInterceptorPlugin;
    }

    @Override
    public void close() throws IOException {
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKeyStr();
    }

    private class HttpHeaderClientConfigurer
    extends HttpClientConfigurer
    implements HttpRequestInterceptor {
        private HttpHeaderClientConfigurer() {
        }

        public void configure(DefaultHttpClient httpClient, SolrParams config) {
            super.configure(httpClient, config);
            httpClient.addRequestInterceptor((HttpRequestInterceptor)this);
        }

        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            if (PKIAuthenticationPlugin.this.disabled()) {
                return;
            }
            PKIAuthenticationPlugin.this.setHeader(httpRequest);
        }
    }

    public static class PKIHeaderData {
        String userName;
        long timestamp;
    }
}

