/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.config;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;

public class SystemPropertiesFactoryBean
extends PropertiesFactoryBean {
    private static final Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
    private int systemPropertiesMode = 2;
    private Set<String> systemProperties = Collections.emptySet();

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public void setSystemProperties(Set<String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        if (this.systemPropertiesMode == 0) {
            for (String string : props.keySet()) {
                this.resolveMergedProperty(string, props);
            }
        } else {
            HashSet<Object> propNames = new HashSet<Object>(props.keySet());
            propNames.addAll(this.systemProperties);
            for (String string : propNames) {
                String systemPropertyValue;
                this.resolveMergedProperty(string, props);
                if (this.systemPropertiesMode == 1 && props.containsKey(string) || (systemPropertyValue = System.getProperty(string)) == null) continue;
                props.put(string, systemPropertyValue);
            }
        }
        return props;
    }

    protected void resolveMergedProperty(String systemProperty, Properties props) {
    }
}

