/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.util.Pair;

public class CannedQueryParameters {
    public static final int DEFAULT_TOTAL_COUNT_MAX = 0;
    private final Object parameterBean;
    private final CannedQueryPageDetails pageDetails;
    private final CannedQuerySortDetails sortDetails;
    private final int totalResultCountMax;
    private final String queryExecutionId;

    public CannedQueryParameters(Object parameterBean) {
        this(parameterBean, null, null, 0, null);
    }

    public CannedQueryParameters(Object parameterBean, int skipResults, int pageSize, String queryExecutionId) {
        this(parameterBean, new CannedQueryPageDetails(skipResults, pageSize, 1, 1), null, 0, queryExecutionId);
    }

    public CannedQueryParameters(Object parameterBean, CannedQueryPageDetails pageDetails, CannedQuerySortDetails sortDetails) {
        this(parameterBean, pageDetails, sortDetails, 0, null);
    }

    public CannedQueryParameters(Object parameterBean, CannedQuerySortDetails sortDetails, PagingRequest pagingRequest) {
        this(parameterBean, pagingRequest == null ? null : new CannedQueryPageDetails(pagingRequest), sortDetails, pagingRequest == null ? 0 : pagingRequest.getRequestTotalCountMax(), pagingRequest == null ? null : pagingRequest.getQueryExecutionId());
    }

    public CannedQueryParameters(Object parameterBean, CannedQueryPageDetails pageDetails, CannedQuerySortDetails sortDetails, int totalResultCountMax, String queryExecutionId) {
        if (totalResultCountMax < 0) {
            throw new IllegalArgumentException("totalResultCountMax cannot be negative.");
        }
        this.parameterBean = parameterBean;
        this.pageDetails = pageDetails == null ? new CannedQueryPageDetails() : pageDetails;
        this.sortDetails = sortDetails == null ? new CannedQuerySortDetails(new Pair[0]) : sortDetails;
        this.totalResultCountMax = totalResultCountMax;
        this.queryExecutionId = queryExecutionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NamedQueryParameters ").append("[parameterBean=").append(this.parameterBean).append(", pageDetails=").append(this.pageDetails).append(", sortDetails=").append(this.sortDetails).append(", requestTotalResultCountMax=").append(this.totalResultCountMax).append(", queryExecutionId=").append(this.queryExecutionId).append("]");
        return sb.toString();
    }

    public String getQueryExecutionId() {
        return this.queryExecutionId;
    }

    public CannedQuerySortDetails getSortDetails() {
        return this.sortDetails;
    }

    public CannedQueryPageDetails getPageDetails() {
        return this.pageDetails;
    }

    public int getTotalResultCountMax() {
        return this.totalResultCountMax;
    }

    public int getResultsRequired() {
        int resultsForPaging = this.pageDetails.getResultsRequiredForPaging();
        if (resultsForPaging < Integer.MAX_VALUE) {
            ++resultsForPaging;
        }
        int maxRequired = Math.max(this.totalResultCountMax, resultsForPaging);
        return maxRequired;
    }

    public Object getParameterBean() {
        return this.parameterBean;
    }
}

