/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseDynamicArgument;

public class BaseFunctionArgument
extends BaseDynamicArgument
implements FunctionArgument {
    private Function function;
    private Map<String, Argument> arguments;

    public BaseFunctionArgument(String name, Function function, Map<String, Argument> arguments) {
        super(name, false, false);
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public Serializable getValue(FunctionEvaluationContext context) {
        return this.function.getValue(this.arguments, context);
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public Map<String, Argument> getFunctionArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseFunctionArgument[");
        builder.append("Name=").append(this.getName()).append(", ");
        builder.append("Function=" + this.getFunction()).append(", ");
        builder.append("Arguments=" + this.getFunctionArguments());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isQueryable() {
        for (Argument arg : this.arguments.values()) {
            if (arg.isQueryable()) continue;
            return false;
        }
        return true;
    }
}

