/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionHelper {
    private static Log logger = LogFactory.getLog(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static Object newObject(String className) {
        Object o = null;
        try {
            Class<?> clazz = Class.forName(className);
            o = clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug((Object)cnfe);
        }
        catch (InstantiationException ie) {
            logger.debug((Object)ie);
        }
        catch (IllegalAccessException iae) {
            logger.debug((Object)iae);
        }
        return o;
    }

    public static Object newObject(String className, Class[] argTypes, Object[] args) {
        if (args == null || args.length == 0) {
            return ReflectionHelper.newObject(className);
        }
        Object o = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> c = clazz.getDeclaredConstructor(argTypes);
            o = c.newInstance(args);
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug((Object)cnfe);
        }
        catch (InstantiationException ie) {
            logger.debug((Object)ie);
        }
        catch (IllegalAccessException iae) {
            logger.debug((Object)iae);
        }
        catch (NoSuchMethodException nsme) {
            logger.debug((Object)nsme);
        }
        catch (InvocationTargetException ite) {
            logger.debug((Object)ite);
        }
        return o;
    }

    public static Object invoke(Object obj, String method, Class[] argTypes, Object[] args) {
        if (obj == null || method == null) {
            throw new IllegalArgumentException("Object and Method must be supplied.");
        }
        try {
            Method m = obj.getClass().getMethod(method, argTypes);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (NoSuchMethodException nsme) {
            logger.debug((Object)nsme);
        }
        catch (IllegalAccessException iae) {
            logger.debug((Object)iae);
        }
        catch (InvocationTargetException ite) {
            logger.debug((Object)ite);
        }
        return null;
    }
}

