/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class TemporalEvaluator
extends ComplexEvaluator {
    private String field;

    public TemporalEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one value but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        Map tupleContext;
        Instant instant = null;
        TemporalAccessor date = null;
        StreamEvaluator streamEvaluator = (StreamEvaluator)this.subEvaluators.get(0);
        Object tupleValue = streamEvaluator.evaluate(tuple);
        if (tupleValue == null) {
            return null;
        }
        if (this.field == null) {
            this.field = streamEvaluator.toExpression(this.constructingFactory).toString();
        }
        if ((date = (LocalDateTime)(tupleContext = this.streamContext.getTupleContext()).get(this.field)) == null) {
            if (tupleValue instanceof String) {
                instant = this.getInstant((String)tupleValue);
            } else if (tupleValue instanceof Long) {
                instant = Instant.ofEpochMilli((Long)tupleValue);
            } else if (tupleValue instanceof Instant) {
                instant = (Instant)tupleValue;
            } else if (tupleValue instanceof Date) {
                instant = ((Date)tupleValue).toInstant();
            } else if (tupleValue instanceof TemporalAccessor) {
                date = (TemporalAccessor)tupleValue;
                tupleContext.put(this.field, date);
            }
        }
        if (instant != null) {
            if ("epoch".equals(this.getFunction())) {
                return instant.toEpochMilli();
            }
            date = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
            tupleContext.put(this.field, date);
        }
        if (date != null) {
            try {
                return this.evaluateDate(date);
            }
            catch (UnsupportedTemporalTypeException utte) {
                throw new IOException(String.format(Locale.ROOT, "It is not possible to call '%s' function on %s", this.getFunction(), date.getClass().getName()));
            }
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid parameter %s - The parameter must be a string formatted ISO_INSTANT or of type Long,Instant,Date,LocalDateTime or TemporalAccessor.", String.valueOf(tupleValue)));
    }

    public abstract Object evaluateDate(TemporalAccessor var1) throws IOException;

    public abstract String getFunction();

    protected Instant getInstant(String dateStr) throws IOException {
        if (dateStr != null && !dateStr.isEmpty()) {
            try {
                return Instant.parse(dateStr);
            }
            catch (DateTimeParseException e) {
                throw new IOException(String.format(Locale.ROOT, "Invalid parameter %s - The String must be formatted in the ISO_INSTANT date format.", dateStr));
            }
        }
        return null;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(this.getFunction());
        for (StreamEvaluator evaluator : this.subEvaluators) {
            expression.addParameter(evaluator.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

