/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String UPLOAD_FILENAME_EXCLUDE_REGEX = "^\\..*$";
    public static final Pattern UPLOAD_FILENAME_EXCLUDE_PATTERN = Pattern.compile("^\\..*$");
    private final SolrZkClient zkClient;

    public ZkConfigManager(SolrZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public void uploadConfigDir(Path dir, String configName) throws IOException {
        this.zkClient.uploadToZK(dir, "/configs/" + configName, UPLOAD_FILENAME_EXCLUDE_PATTERN);
    }

    public void uploadConfigDir(Path dir, String configName, Pattern filenameExclusions) throws IOException {
        this.zkClient.uploadToZK(dir, "/configs/" + configName, filenameExclusions);
    }

    public void downloadConfigDir(String configName, Path dir) throws IOException {
        this.zkClient.downloadFromZK("/configs/" + configName, dir);
    }

    public List<String> listConfigs() throws IOException {
        try {
            return this.zkClient.getChildren(CONFIGS_ZKNODE, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error listing configs", SolrZkClient.checkInterrupted(e));
        }
    }

    public Boolean configExists(String configName) throws IOException {
        try {
            return this.zkClient.exists("/configs/" + configName, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error checking whether config exists", SolrZkClient.checkInterrupted(e));
        }
    }

    public void deleteConfigDir(String configName) throws IOException {
        try {
            this.zkClient.clean("/configs/" + configName);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error checking whether config exists", SolrZkClient.checkInterrupted(e));
        }
    }

    private void copyConfigDirFromZk(String fromZkPath, String toZkPath, Set<String> copiedToZkPaths) throws IOException {
        try {
            List<String> files = this.zkClient.getChildren(fromZkPath, null, true);
            for (String file : files) {
                List<String> children = this.zkClient.getChildren(fromZkPath + "/" + file, null, true);
                if (children.size() == 0) {
                    this.copyData(copiedToZkPaths, fromZkPath + "/" + file, toZkPath + "/" + file);
                    continue;
                }
                this.copyConfigDirFromZk(fromZkPath + "/" + file, toZkPath + "/" + file, copiedToZkPaths);
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error copying nodes from zookeeper path " + fromZkPath + " to " + toZkPath, SolrZkClient.checkInterrupted(e));
        }
    }

    private void copyData(Set<String> copiedToZkPaths, String fromZkFilePath, String toZkFilePath) throws KeeperException, InterruptedException {
        logger.info("Copying zk node {} to {}", (Object)fromZkFilePath, (Object)toZkFilePath);
        byte[] data = this.zkClient.getData(fromZkFilePath, null, null, true);
        this.zkClient.makePath(toZkFilePath, data, true);
        if (copiedToZkPaths != null) {
            copiedToZkPaths.add(toZkFilePath);
        }
    }

    public void copyConfigDir(String fromConfig, String toConfig) throws IOException {
        this.copyConfigDir("/configs/" + fromConfig, "/configs/" + toConfig, null);
    }

    public void copyConfigDir(String fromConfig, String toConfig, Set<String> copiedToZkPaths) throws IOException {
        String fromConfigPath = "/configs/" + fromConfig;
        String toConfigPath = "/configs/" + toConfig;
        try {
            this.copyData(copiedToZkPaths, fromConfigPath, toConfigPath);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error config " + fromConfig + " to " + toConfig, SolrZkClient.checkInterrupted(e));
        }
        this.copyConfigDirFromZk("/configs/" + fromConfig, "/configs/" + toConfig, copiedToZkPaths);
    }

    public static Path getConfigsetPath(String confDir, String configSetDir) throws IOException {
        Path ret = Paths.get(confDir, "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Paths.get(confDir, new String[0]).normalize();
        }
        ret = Paths.get(confDir, "conf", "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Paths.get(confDir, "conf").normalize();
        }
        ret = Paths.get(configSetDir, confDir, "conf", "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Paths.get(configSetDir, confDir, "conf").normalize();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find solrconfig.xml at %s, %s or %s", Paths.get(configSetDir, "solrconfig.xml").normalize().toAbsolutePath().toString(), Paths.get(configSetDir, "conf", "solrconfig.xml").normalize().toAbsolutePath().toString(), Paths.get(configSetDir, confDir, "conf", "solrconfig.xml").normalize().toAbsolutePath().toString()));
    }
}

