/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Persister;

@Root(name="searchresult", strict=false)
public final class ProcessingResult {
    private Map<String, Object> attributes = Maps.newHashMap();
    private Map<String, Object> attributesView;
    @Element(required=false)
    private String query;
    @ElementList(inline=true, required=false)
    private List<Document> documents;
    @ElementList(inline=true, required=false)
    private List<Cluster> clusters;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherAttributesForSerialization;

    ProcessingResult() {
        this(new HashMap<String, Object>());
    }

    ProcessingResult(Map<String, Object> attributes) {
        List clusters;
        this.attributes = attributes;
        List documents = (List)attributes.get("documents");
        if (documents != null) {
            Document.assignDocumentIds(documents);
            attributes.put("documents", Collections.unmodifiableList(documents));
        }
        if ((clusters = (List)attributes.get("clusters")) != null) {
            Cluster.assignClusterIds(clusters);
            attributes.put("clusters", Collections.unmodifiableList(clusters));
        }
        this.attributesView = Collections.unmodifiableMap(attributes);
    }

    public Map<String, Object> getAttributes() {
        return this.attributesView;
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributesView.get(key);
    }

    public List<Document> getDocuments() {
        return (List)this.attributes.get("documents");
    }

    public List<Cluster> getClusters() {
        return (List)this.attributes.get("clusters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Persist
    private void beforeSerialization() {
        ProcessingResult processingResult = this;
        synchronized (processingResult) {
            this.query = (String)this.attributes.get("query");
            this.documents = this.getDocuments() != null ? Lists.newArrayList(this.getDocuments()) : null;
            this.clusters = this.getClusters() != null ? Lists.newArrayList(this.getClusters()) : null;
            this.otherAttributesForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.attributes));
            this.otherAttributesForSerialization.remove("query");
            this.otherAttributesForSerialization.remove("clusters");
            this.otherAttributesForSerialization.remove("documents");
            if (this.otherAttributesForSerialization.isEmpty()) {
                this.otherAttributesForSerialization = null;
            }
        }
    }

    @Commit
    private void afterDeserialization() throws Exception {
        if (this.otherAttributesForSerialization != null) {
            this.attributes = SimpleXmlWrappers.unwrap(this.otherAttributesForSerialization);
        }
        this.attributesView = Collections.unmodifiableMap(this.attributes);
        this.attributes.put("query", this.query != null ? this.query.trim() : null);
        this.attributes.put("documents", this.documents);
        this.attributes.put("clusters", this.clusters);
        if (this.clusters != null && this.documents != null) {
            HashMap documentsById = Maps.newHashMap();
            for (Document document : this.documents) {
                documentsById.put(document.getStringId(), document);
            }
            for (Cluster cluster : this.clusters) {
                this.documentIdToReference(cluster, documentsById);
            }
        }
    }

    private void documentIdToReference(Cluster cluster, Map<String, Document> documents) {
        if (cluster.documentIds != null) {
            for (Cluster.DocumentRefid documentRefid : cluster.documentIds) {
                cluster.addDocuments(documents.get(documentRefid.refid));
            }
        }
        for (Cluster subcluster : cluster.getSubclusters()) {
            this.documentIdToReference(subcluster, documents);
        }
    }

    public String serialize() {
        try {
            StringWriter sw = new StringWriter();
            new Persister().write((Object)this, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(OutputStream stream) throws Exception {
        this.serialize(stream, true, true);
    }

    public void serialize(OutputStream stream, boolean saveDocuments, boolean saveClusters) throws Exception {
        this.serialize(stream, saveDocuments, saveClusters, true);
    }

    public void serialize(OutputStream stream, boolean saveDocuments, boolean saveClusters, boolean saveOtherAttributes) throws Exception {
        Map<String, Object> backupAttributes = this.attributes;
        this.attributes = this.prepareAttributesForSerialization(saveDocuments, saveClusters, saveOtherAttributes);
        new Persister().write((Object)this, stream);
        this.attributes = backupAttributes;
    }

    public static ProcessingResult deserialize(CharSequence input) throws Exception {
        return (ProcessingResult)new Persister().read(ProcessingResult.class, input.toString());
    }

    public static ProcessingResult deserialize(InputStream input) throws Exception {
        return (ProcessingResult)new Persister().read(ProcessingResult.class, input);
    }

    public void serializeJson(Writer writer) throws IOException {
        this.serializeJson(writer, null);
    }

    public void serializeJson(Writer writer, String callback) throws IOException {
        this.serializeJson(writer, callback, true, true);
    }

    public void serializeJson(Writer writer, String callback, boolean saveDocuments, boolean saveClusters) throws IOException {
        this.serializeJson(writer, callback, false, saveDocuments, saveClusters);
    }

    public void serializeJson(Writer writer, String callback, boolean indent, boolean saveDocuments, boolean saveClusters) throws IOException {
        this.serializeJson(writer, callback, indent, saveDocuments, saveClusters, true);
    }

    public void serializeJson(Writer writer, String callback, boolean indent, boolean saveDocuments, boolean saveClusters, boolean saveOtherAttributes) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        if (StringUtils.isNotBlank((String)callback)) {
            writer.write(callback + "(");
        }
        Map<String, Object> attrs = this.prepareAttributesForSerialization(saveDocuments, saveClusters, saveOtherAttributes);
        mapper.writeValue(writer, attrs);
        if (StringUtils.isNotBlank((String)callback)) {
            writer.write(");");
        }
    }

    private Map<String, Object> prepareAttributesForSerialization(boolean saveDocuments, boolean saveClusters, boolean saveOtherAttributes) {
        HashMap tempAttributes = Maps.newHashMap();
        if (saveOtherAttributes) {
            tempAttributes.putAll(this.attributes);
            tempAttributes.remove("documents");
            tempAttributes.remove("clusters");
        } else {
            tempAttributes.put("query", this.attributes.get("query"));
        }
        if (saveDocuments) {
            tempAttributes.put("documents", this.getDocuments());
        }
        if (saveClusters) {
            tempAttributes.put("clusters", this.getClusters());
        }
        return tempAttributes;
    }
}

