/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.mahout.math.list;

import java.util.ArrayList;
import java.util.List;
import org.carrot2.mahout.math.Arrays;
import org.carrot2.mahout.math.Sorting;
import org.carrot2.mahout.math.buffer.IntBufferConsumer;
import org.carrot2.mahout.math.function.IntComparator;
import org.carrot2.mahout.math.function.IntProcedure;
import org.carrot2.mahout.math.list.AbstractList;
import org.carrot2.mahout.math.list.IntArrayList;

public abstract class AbstractIntList
extends AbstractList
implements IntBufferConsumer,
Cloneable {
    protected int size;

    public void add(int element) {
        this.beforeInsert(this.size, element);
    }

    public void addAllOf(AbstractIntList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void addAllOfFromTo(AbstractIntList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    @Override
    public void addAllOf(IntArrayList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void beforeInsert(int index, int element) {
        this.beforeInsertDummies(index, 1);
        this.set(index, element);
    }

    public void beforeInsertAllOfFromTo(int index, AbstractIntList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            this.setSizeRaw(this.size + length);
            this.replaceFromToWithFrom(index + length, this.size - 1, this, index);
        }
    }

    public int binarySearch(int key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(int key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midVal = this.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(int elem) {
        return this.indexOfFromTo(elem, 0, this.size - 1) >= 0;
    }

    public void delete(int element) {
        int index = this.indexOfFromTo(element, 0, this.size - 1);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public int[] elements() {
        int[] myElements = new int[this.size];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public AbstractIntList elements(int[] elements) {
        this.clear();
        this.addAllOfFromTo(new IntArrayList(elements), 0, elements.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof AbstractIntList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        AbstractIntList other = (AbstractIntList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            if (this.getQuick(i) == other.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int from, int to, int val) {
        AbstractIntList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(IntProcedure procedure) {
        int i = 0;
        while (i < this.size) {
            if (procedure.apply(this.get(i++))) continue;
            return false;
        }
        return true;
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getQuick(index);
    }

    protected abstract int getQuick(int var1);

    public int indexOf(int element) {
        return this.indexOfFromTo(element, 0, this.size - 1);
    }

    public int indexOfFromTo(int element, int from, int to) {
        AbstractIntList.checkRangeFromTo(from, to, this.size);
        for (int i = from; i <= to; ++i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(int element, int from, int to) {
        AbstractIntList.checkRangeFromTo(from, to, this.size());
        for (int i = to; i >= from; --i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractIntList.checkRangeFromTo(from, to, mySize);
        int[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void mergeSortFromTo(int from, int to, IntComparator c) {
        int mySize = this.size();
        AbstractIntList.checkRangeFromTo(from, to, mySize);
        int[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public AbstractIntList partFromTo(int from, int to) {
        AbstractIntList.checkRangeFromTo(from, to, this.size);
        int length = to - from + 1;
        IntArrayList part = new IntArrayList(length);
        part.addAllOfFromTo(this, from, to);
        return part;
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractIntList.checkRangeFromTo(from, to, mySize);
        int[] myElements = this.elements();
        java.util.Arrays.sort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void quickSortFromTo(int from, int to, IntComparator c) {
        int mySize = this.size();
        AbstractIntList.checkRangeFromTo(from, to, mySize);
        int[] myElements = this.elements();
        Sorting.quickSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public boolean removeAll(AbstractIntList other) {
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) >= 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        AbstractIntList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved > 0) {
            this.replaceFromToWithFrom(from, from - 1 + numMoved, this, to + 1);
        }
        if ((width = to - from + 1) > 0) {
            this.setSizeRaw(this.size - width);
        }
    }

    public void replaceFromToWithFrom(int from, int to, AbstractIntList other, int otherFrom) {
        block4: {
            int length = to - from + 1;
            if (length <= 0) break block4;
            AbstractIntList.checkRangeFromTo(from, to, this.size());
            AbstractIntList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            if (from <= otherFrom) {
                while (--length >= 0) {
                    this.setQuick(from++, other.getQuick(otherFrom++));
                }
            } else {
                int otherTo = otherFrom + length - 1;
                while (--length >= 0) {
                    this.setQuick(to--, other.getQuick(otherTo--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int from, int to, AbstractIntList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            this.replaceFromToWithFrom(from, from + length - 1, other, otherFrom);
        }
    }

    public boolean retainAll(AbstractIntList other) {
        if (other.isEmpty()) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) < 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size() / 2;
        int j = this.size() - 1;
        int i = 0;
        while (i < limit) {
            int tmp = this.getQuick(i);
            this.setQuick(i++, this.getQuick(j));
            this.setQuick(j--, tmp);
        }
    }

    public void set(int index, int element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.setQuick(index, element);
    }

    protected abstract void setQuick(int var1, int var2);

    protected void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractIntList times(int times) {
        IntArrayList newList = new IntArrayList(times * this.size());
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    public List<Integer> toList() {
        int mySize = this.size();
        ArrayList<Integer> list = new ArrayList<Integer>(mySize);
        for (int i = 0; i < mySize; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public int[] toArray(int[] values) {
        int mySize = this.size();
        int[] myElements = values.length >= mySize ? values : new int[mySize];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

