/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class PathTokenFilter
extends Tokenizer {
    public static final String INTEGER_FORMAT = "0000000000";
    public static final char PATH_SEPARATOR = ';';
    public static final char NAMESPACE_START_DELIMITER = '{';
    public static final char NAMESPACE_END_DELIMITER = '}';
    public static final String SEPARATOR_TOKEN_TEXT = ";";
    public static final String NO_NS_TOKEN_TEXT = "<No Namespace>";
    public static final String TOKEN_TYPE_PATH_SEP = "PATH_SEPARATOR";
    public static final String TOKEN_TYPE_PATH_LENGTH = "PATH_LENGTH";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAME = "PATH_ELEMENT_NAME";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAMESPACE = "PATH_ELEMENT_NAMESPACE";
    public static final String TOKEN_TYPE_PATH_ELEMENT_NAMESPACE_PREFIX = "PATH_ELEMENT_NAMESPACE_PREFIX";
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    char pathSeparator;
    String separatorTokenText;
    String noNsTokenText;
    char nsStartDelimiter;
    int nsStartDelimiterLength;
    char nsEndDelimiter;
    int nsEndDelimiterLength;
    char nsPrefixDelimiter = (char)58;
    LinkedList<PackedTokenAttributeImpl> tokens = new LinkedList();
    Iterator<PackedTokenAttributeImpl> it = null;
    private boolean includeNamespace;
    private boolean endOfStream = false;
    int readerPosition = 0;

    public PathTokenFilter(char pathSeparator, String separatorTokenText, String noNsTokenText, char nsStartDelimiter, char nsEndDelimiter, boolean includeNameSpace) {
        this.pathSeparator = pathSeparator;
        this.separatorTokenText = separatorTokenText;
        this.noNsTokenText = noNsTokenText;
        this.nsStartDelimiter = nsStartDelimiter;
        this.nsEndDelimiter = nsEndDelimiter;
        this.includeNamespace = includeNameSpace;
        this.nsStartDelimiterLength = 1;
        this.nsEndDelimiterLength = 1;
    }

    public PackedTokenAttributeImpl next() throws IOException {
        if (this.it == null) {
            this.buildTokenListAndIterator();
        }
        PackedTokenAttributeImpl nextToken = this.it.hasNext() ? this.it.next() : null;
        return nextToken;
    }

    private String termText(PackedTokenAttributeImpl token) {
        return new String(token.buffer(), 0, token.length());
    }

    private void buildTokenListAndIterator() throws IOException {
        PackedTokenAttributeImpl t;
        DecimalFormat nf = new DecimalFormat(INTEGER_FORMAT);
        int insertCountAt = 0;
        int lengthCounter = 0;
        PackedTokenAttributeImpl pathSplitToken = null;
        PackedTokenAttributeImpl nameToken = null;
        PackedTokenAttributeImpl countToken = null;
        PackedTokenAttributeImpl namespaceToken = null;
        while ((t = this.nextToken()) != null) {
            String text = this.termText(t);
            if (text.length() == 0) continue;
            if (text.charAt(text.length() - 1) == this.pathSeparator) {
                text = text.substring(0, text.length() - 1);
                pathSplitToken = new PackedTokenAttributeImpl();
                pathSplitToken.setEmpty().append(this.separatorTokenText);
                pathSplitToken.setOffset(t.startOffset(), t.endOffset());
                pathSplitToken.setType(TOKEN_TYPE_PATH_SEP);
                pathSplitToken.setPositionIncrement(1);
            }
            int split = -1;
            boolean isPrefix = false;
            if (text.length() > 0 && text.charAt(0) == this.nsStartDelimiter) {
                split = text.indexOf(this.nsEndDelimiter);
            }
            if (split == -1) {
                split = text.indexOf(this.nsPrefixDelimiter);
                isPrefix = true;
            }
            if (split == -1) {
                namespaceToken = new PackedTokenAttributeImpl();
                namespaceToken.setEmpty().append(this.noNsTokenText);
                namespaceToken.setOffset(t.startOffset(), t.startOffset());
                namespaceToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                nameToken = new PackedTokenAttributeImpl();
                nameToken.setEmpty().append(text);
                nameToken.setOffset(t.startOffset(), t.endOffset());
                nameToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAME);
            } else if (isPrefix) {
                namespaceToken = new PackedTokenAttributeImpl();
                namespaceToken.setEmpty().append(text.substring(0, split));
                namespaceToken.setOffset(t.startOffset(), t.startOffset() + split);
                namespaceToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAMESPACE_PREFIX);
                nameToken = new PackedTokenAttributeImpl();
                nameToken.setEmpty().append(text.substring(split + 1));
                nameToken.setOffset(t.startOffset() + split + 1, t.endOffset());
                nameToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAME);
            } else {
                namespaceToken = new PackedTokenAttributeImpl();
                namespaceToken.setEmpty().append(text.substring(this.nsStartDelimiterLength, split + this.nsEndDelimiterLength - 1));
                namespaceToken.setOffset(t.startOffset(), t.startOffset() + split);
                namespaceToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                nameToken = new PackedTokenAttributeImpl();
                nameToken.setEmpty().append(text.substring(split + this.nsEndDelimiterLength));
                nameToken.setOffset(t.startOffset() + split + this.nsEndDelimiterLength, t.endOffset());
                nameToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAME);
            }
            namespaceToken.setPositionIncrement(1);
            nameToken.setPositionIncrement(1);
            if (this.includeNamespace) {
                if (this.termText(namespaceToken).equals("")) {
                    namespaceToken = new PackedTokenAttributeImpl();
                    namespaceToken.setEmpty().append(this.noNsTokenText);
                    namespaceToken.setOffset(t.startOffset(), t.startOffset());
                    namespaceToken.setType(TOKEN_TYPE_PATH_ELEMENT_NAMESPACE);
                    namespaceToken.setPositionIncrement(1);
                }
                this.tokens.add(namespaceToken);
            }
            this.tokens.add(nameToken);
            ++lengthCounter;
            if (pathSplitToken == null) continue;
            String countString = nf.format(lengthCounter);
            countToken = new PackedTokenAttributeImpl();
            countToken.setEmpty().append(countString);
            countToken.setOffset(t.startOffset(), t.endOffset());
            countToken.setType(TOKEN_TYPE_PATH_SEP);
            countToken.setPositionIncrement(1);
            this.tokens.add(insertCountAt, countToken);
            this.tokens.add(pathSplitToken);
            lengthCounter = 0;
            insertCountAt = this.tokens.size();
            pathSplitToken = null;
        }
        String countString = nf.format(lengthCounter);
        countToken = new PackedTokenAttributeImpl();
        countToken.setEmpty().append(countString);
        countToken.setOffset(0, 0);
        countToken.setType(TOKEN_TYPE_PATH_SEP);
        countToken.setPositionIncrement(1);
        this.tokens.add(insertCountAt, countToken);
        if (this.tokens.size() == 0 || !this.termText(this.tokens.get(this.tokens.size() - 1)).equals(TOKEN_TYPE_PATH_SEP)) {
            pathSplitToken = new PackedTokenAttributeImpl();
            pathSplitToken.setEmpty().append(this.separatorTokenText);
            pathSplitToken.setOffset(0, 0);
            pathSplitToken.setType(TOKEN_TYPE_PATH_SEP);
            pathSplitToken.setPositionIncrement(1);
            this.tokens.add(pathSplitToken);
        }
        this.it = this.tokens.iterator();
    }

    private PackedTokenAttributeImpl nextToken() throws IOException {
        int current;
        if (this.endOfStream) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(64);
        boolean inNameSpace = false;
        int start = this.readerPosition;
        while ((current = this.input.read()) != -1) {
            char c = (char)current;
            ++this.readerPosition;
            if (c == this.nsStartDelimiter) {
                inNameSpace = true;
            } else if (c == this.nsEndDelimiter) {
                inNameSpace = false;
            } else {
                if (!inNameSpace && c == '/') {
                    PackedTokenAttributeImpl qNameToken = new PackedTokenAttributeImpl();
                    qNameToken.setEmpty().append(buffer.toString());
                    qNameToken.setOffset(start, this.readerPosition - 1);
                    qNameToken.setType("QNAME");
                    return qNameToken;
                }
                if (!inNameSpace && c == ';') {
                    buffer.append(c);
                    PackedTokenAttributeImpl lastQNameToken = new PackedTokenAttributeImpl();
                    lastQNameToken.setEmpty().append(buffer.toString());
                    lastQNameToken.setOffset(start, this.readerPosition);
                    lastQNameToken.setType("LASTQNAME");
                    return lastQNameToken;
                }
            }
            buffer.append(c);
        }
        int end = this.readerPosition - 1;
        if (start > end) {
            end = start;
        }
        this.endOfStream = true;
        if (!inNameSpace) {
            PackedTokenAttributeImpl qNameToken = new PackedTokenAttributeImpl();
            qNameToken.setEmpty().append(buffer.toString());
            qNameToken.setOffset(start, end);
            qNameToken.setType("QNAME");
            return qNameToken;
        }
        throw new IllegalStateException("QName terminated incorrectly: " + buffer.toString());
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        PackedTokenAttributeImpl next = this.next();
        if (next == null) {
            return false;
        }
        this.termAtt.copyBuffer(next.buffer(), 0, next.length());
        this.offsetAtt.setOffset(this.correctOffset(next.startOffset()), this.correctOffset(next.endOffset()));
        this.typeAtt.setType(next.type());
        this.posIncAtt.setPositionIncrement(next.getPositionIncrement());
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
        this.it = null;
        this.readerPosition = 0;
        this.endOfStream = false;
    }

    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.readerPosition);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }
}

