/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.config;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    protected static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String JNDI_PREFIX = "java:comp/env/";
    private static final String ENV_PREFIX = "SOLR_";

    public static String locateProperty(String propertyName, String defaultValue) {
        String propertyValue = null;
        String propertyKey = propertyName;
        String jndiKey = ConfigUtil.convertPropertyNameToJNDIPath(propertyKey);
        String envVar = ConfigUtil.convertPropertyNameToEnvironmentParam(propertyKey);
        try {
            InitialContext c = new InitialContext();
            propertyValue = (String)c.lookup(jndiKey);
            log.debug("Using JNDI key: " + jndiKey + ": " + propertyValue);
            return propertyValue;
        }
        catch (NoInitialContextException e) {
            log.debug("JNDI not configured (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.debug("No " + jndiKey + " in JNDI");
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        propertyValue = System.getProperty(propertyKey);
        if (propertyValue != null) {
            log.debug("Using system property " + propertyKey + ": " + propertyValue);
            return propertyValue;
        }
        propertyValue = System.getProperty("solr." + propertyKey);
        if (propertyValue != null) {
            log.debug("Using system property solr." + propertyKey + ": " + propertyValue);
            return propertyValue;
        }
        propertyValue = System.getenv(envVar);
        if (propertyValue != null) {
            log.debug("Using environment variable " + envVar + ": " + propertyValue);
            return propertyValue;
        }
        log.debug("Using default value for variable " + propertyName + ": " + defaultValue);
        return defaultValue;
    }

    protected static String convertPropertyNameToJNDIPath(String propertyName) {
        if (propertyName == null) {
            propertyName = "";
        }
        return JNDI_PREFIX + propertyName.replace('.', '/');
    }

    protected static String convertPropertyNameToEnvironmentParam(String propertyName) {
        if (propertyName == null) {
            propertyName = "";
        }
        return ENV_PREFIX + propertyName.replace('.', '_').toUpperCase();
    }
}

