/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.Tracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActivatableTracker
extends AbstractTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivatableTracker.class);
    protected static AtomicBoolean isEnabled = new AtomicBoolean(true);

    protected ActivatableTracker(Tracker.Type type) {
        super(type);
    }

    protected ActivatableTracker(Properties properties, SOLRAPIClient client, String coreName, InformationServer informationServer, Tracker.Type type) {
        super(properties, client, coreName, informationServer, type);
        if (isEnabled.get()) {
            LOGGER.info("[{} / {} / {}] {} Tracker set to enabled at startup.", new Object[]{coreName, this.trackerId, this.state, type});
        } else {
            LOGGER.info("[{} / {} / {}] {} Tracker set to disabled at startup.", new Object[]{coreName, this.trackerId, this.state, type});
        }
    }

    public final void disable() {
        this.clearScheduledMaintenanceWork();
        if (isEnabled.compareAndSet(true, false) && this.state != null && this.state.isRunning()) {
            this.setRollback(true, null);
        }
        LOGGER.info("[{} / {} / {}] {} Tracker has been disabled.", new Object[]{this.coreName, this.trackerId, this.state, this.type});
    }

    public final void enable() {
        isEnabled.set(true);
        LOGGER.info("[{} / {} / {}] {} Tracker has been enabled", new Object[]{this.coreName, this.trackerId, this.state, this.type});
    }

    @Override
    public void track() {
        if (this.isEnabled()) {
            super.track();
        } else {
            LOGGER.trace("[{} / {} / {}] {} Tracker is disabled. That is absolutely ok, that means you disabled the tracking on this core.", new Object[]{this.coreName, this.trackerId, this.state, this.type});
        }
    }

    public boolean isEnabled() {
        return isEnabled.get();
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    protected void clearScheduledMaintenanceWork() {
    }

    protected void logAndClear(Collection<Long> values, String kind) {
        if (values == null || values.size() == 0) {
            return;
        }
        ArrayList<Long> tmp = new ArrayList<Long>(values);
        values.clear();
        LOGGER.info("[CORE {}] Scheduled work ({}) that will be cleaned: {}", new Object[]{this.coreName, kind, new ArrayList<Long>(tmp)});
    }
}

